/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.R;

public class NotificationHandler {
    private static final int NOTIFICATION_ID = 1212322;
    private final String mTitle;
    private final String mMessage;
    private final Context mContext;
    private int mIconResourceId;
    private PendingIntent mPendingIntent;

    public NotificationHandler(Context context, String title, String message) {
        this.mContext = context;
        this.mTitle = title;
        this.mMessage = message;
    }

    public NotificationHandler setIconResourceId(int iconResourceId) {
        this.mIconResourceId = iconResourceId;
        return this;
    }

    public NotificationHandler setPendingIntent(PendingIntent pendingIntent) {
        this.mPendingIntent = pendingIntent;
        return this;
    }

    public void showNotification() {
        Notification notification = this.createPushNotificationBuilder().build();
        Android.getNotificationManager(this.mContext).notify(1212322, notification);
    }

    private Notification.Builder createPushNotificationBuilder() {
        String channelId = this.mContext.getString(R.string.push_notification_channel_id);
        String channelName = this.mContext.getString(R.string.push_notification_channel_name);
        Notification.Builder builder = Android.createNotificationBuilder(this.mContext, channelId, channelName);
        builder.setContentTitle((CharSequence)this.mTitle).setAutoCancel(true).setDefaults(5).setSmallIcon(this.mIconResourceId).setContentText((CharSequence)this.mMessage).setCategory("msg").setPriority(1);
        return builder;
    }

    public Notification.Builder createForegroundServiceNotificationBuilder() {
        String channelId = this.mContext.getString(R.string.foreground_service_notification_channel_id);
        String channelName = this.mContext.getString(R.string.foreground_service_notification_channel_name);
        Notification.Builder builder = Android.createNotificationBuilder(this.mContext, channelId, channelName);
        builder = builder.setContentTitle((CharSequence)this.mTitle).setSmallIcon(this.mIconResourceId).setLargeIcon(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.mIconResourceId)).setContentIntent(this.mPendingIntent).setProgress(0, 0, true);
        return builder;
    }

    public static class Android {
        public static void hideNotification(Context context, String brandId) {
            ((NotificationManager)context.getSystemService("notification")).cancel(brandId, 1212322);
        }

        public static Notification.Builder createNotificationBuilder(Context context, String channelId, String channelName) {
            Notification.Builder builder;
            if (Build.VERSION.SDK_INT < 26) {
                builder = new Notification.Builder(context);
            } else {
                Android.createNotificationChannel(context, channelId, channelName);
                builder = new Notification.Builder(context, channelId);
            }
            return builder;
        }

        @RequiresApi(api=26)
        @VisibleForTesting
        public static void createNotificationChannel(Context context, String channelId, String channelName) {
            NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
            Android.getNotificationManager(context).createNotificationChannel(notificationChannel);
        }

        @VisibleForTesting
        public static NotificationManager getNotificationManager(Context context) {
            return (NotificationManager)context.getSystemService("notification");
        }
    }
}

