/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log;

import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.AndroidLoggingDelegate;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LogLevel;
import com.liveperson.infra.log.LogLine;
import com.liveperson.infra.log.LoggingDelegate;
import com.liveperson.infra.log.LoggingQueue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J&\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0006J(\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J&\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0006J.\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0013J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010'\u001a\u00020\u0013J\u001e\u0010*\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J&\u0010*\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010*\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J \u0010*\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0012\u0010+\u001a\u0004\u0018\u00010\u00062\b\u0010,\u001a\u0004\u0018\u00010\u0001J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010.\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J(\u0010.\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0016\u0010.\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J \u0010.\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u001e\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006J&\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J \u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/liveperson/infra/log/LPLog;", "", "()V", "MAX_LOG_HISTORY", "", "START_OF_LOGS", "", "TAG", "dataMaskingEnabled", "", "getDataMaskingEnabled", "()Z", "setDataMaskingEnabled", "(Z)V", "history", "Lcom/liveperson/infra/log/LoggingQueue;", "loggingDelegate", "Lcom/liveperson/infra/log/LoggingDelegate;", "loggingLevel", "Lcom/liveperson/infra/log/LogLevel;", "getLoggingLevel", "()Lcom/liveperson/infra/log/LogLevel;", "setLoggingLevel", "(Lcom/liveperson/infra/log/LogLevel;)V", "clearHistory", "", "d", "tag", "flowTag", "Lcom/liveperson/infra/log/FlowTags;", "message", "exception", "", "e", "errCode", "Lcom/liveperson/infra/errors/ErrorCode;", "getLogSnapshot", "", "Lcom/liveperson/infra/log/LogLine;", "level", "getLogSnapshotStringBlock", "getLogSnapshotStrings", "i", "mask", "pii", "setLoggingDelegate", "v", "w", "infra_release"})
public final class LPLog {
    @NotNull
    public static final LPLog INSTANCE = new LPLog();
    @NotNull
    private static final String TAG = "LivePerson";
    private static final int MAX_LOG_HISTORY = 100;
    @NotNull
    private static final String START_OF_LOGS = "== Start of LivePerson Logs ==";
    @NotNull
    private static LoggingDelegate loggingDelegate = new AndroidLoggingDelegate();
    @NotNull
    private static final LoggingQueue history = new LoggingQueue(100);
    @NotNull
    private static LogLevel loggingLevel = LogLevel.INFO;
    private static boolean dataMaskingEnabled = true;

    private LPLog() {
    }

    @NotNull
    public final LogLevel getLoggingLevel() {
        return loggingLevel;
    }

    public final void setLoggingLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        loggingLevel = logLevel;
    }

    public final boolean getDataMaskingEnabled() {
        return dataMaskingEnabled;
    }

    public final void setDataMaskingEnabled(boolean bl) {
        dataMaskingEnabled = bl;
    }

    public final void setLoggingDelegate(@NotNull LoggingDelegate loggingDelegate) {
        Intrinsics.checkNotNullParameter((Object)loggingDelegate, (String)"loggingDelegate");
        LPLog.loggingDelegate = loggingDelegate;
    }

    public final void v(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.v(tag, message, null);
    }

    public final void v(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.v(tag + "::" + flowTag.getApiName(), message, null);
    }

    public final void v(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.v(tag + "::" + flowTag.getApiName(), message, exception);
    }

    public final void v(@NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        history.add(new LogLine(LogLevel.VERBOSE, tag, message, exception));
        if (LogLevel.VERBOSE.compareTo((Enum)loggingLevel) <= 0) {
            loggingDelegate.v(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public final void d(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.d(tag, message, null);
    }

    public final void d(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.d(tag + "::" + flowTag.getApiName(), message, null);
    }

    public final void d(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.d(tag + "::" + flowTag.getApiName(), message, exception);
    }

    public final void d(@NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        history.add(new LogLine(LogLevel.DEBUG, tag, message, exception));
        if (LogLevel.DEBUG.compareTo((Enum)loggingLevel) <= 0) {
            loggingDelegate.d(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public final void i(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.i(tag, message, null);
    }

    public final void i(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.i(tag + "::" + flowTag.getApiName(), message, null);
    }

    public final void i(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.i(tag + "::" + flowTag.getApiName(), message, exception);
    }

    public final void i(@NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        history.add(new LogLine(LogLevel.INFO, tag, message, exception));
        if (LogLevel.INFO.compareTo((Enum)loggingLevel) <= 0) {
            loggingDelegate.i(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public final void w(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.w(tag, message, null);
    }

    public final void w(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.w(tag + "::" + flowTag.getApiName(), message, null);
    }

    public final void w(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull String message, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.w(tag + "::" + flowTag.getApiName(), message, exception);
    }

    public final void w(@NotNull String tag, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        history.add(new LogLine(LogLevel.WARNING, tag, message, exception));
        if (LogLevel.WARNING.compareTo((Enum)loggingLevel) <= 0) {
            loggingDelegate.w(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public final void e(@NotNull String tag, @NotNull ErrorCode errCode, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)errCode), (String)"errCode");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.e(tag, errCode, message, null);
    }

    public final void e(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull ErrorCode errCode, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)((Object)errCode), (String)"errCode");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.e(tag + "::" + flowTag.getApiName(), errCode, message, null);
    }

    public final void e(@NotNull String tag, @NotNull FlowTags flowTag, @NotNull ErrorCode errCode, @NotNull String message, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)flowTag), (String)"flowTag");
        Intrinsics.checkNotNullParameter((Object)((Object)errCode), (String)"errCode");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.e(tag + "::" + flowTag.getApiName(), errCode, message, exception);
    }

    public final void e(@NotNull String tag, @NotNull ErrorCode errCode, @NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)errCode), (String)"errCode");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        history.add(new LogLine(LogLevel.ERROR, tag, '[' + errCode.name() + "] " + message, exception));
        if (LogLevel.ERROR.compareTo((Enum)loggingLevel) <= 0) {
            loggingDelegate.e(TAG, "[[" + tag + "]]  [" + errCode.name() + "] " + message, exception);
        }
        if (Infra.instance.isInitialized()) {
            Infra.instance.getLoggos().reportError();
        }
    }

    @Nullable
    public final String mask(@Nullable Object pii) {
        String string;
        if (dataMaskingEnabled) {
            String string2;
            Object object = pii;
            String string3 = string2 = object != null ? object.toString() : null;
            string = string2 == null ? null : (Intrinsics.areEqual((Object)string2, (Object)"") ? "" : "********");
        } else {
            Object object = pii;
            string = object != null ? object.toString() : null;
        }
        return string;
    }

    @NotNull
    public final List<LogLine> getLogSnapshot(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return history.getLogSnapshot(level);
    }

    @NotNull
    public final List<String> getLogSnapshotStrings(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return history.getLogSnapshotStrings(level);
    }

    @NotNull
    public final String getLogSnapshotStringBlock(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return history.getLogSnapshotStringBlock(level);
    }

    public final void clearHistory() {
        history.clear();
        history.add(new LogLine(LogLevel.INFO, TAG, START_OF_LOGS, null));
    }

    static {
        history.add(new LogLine(LogLevel.INFO, TAG, START_OF_LOGS, null));
    }
}

