/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.utils.EncryptionVersion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u001cJ\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J \u0010$\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010(H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0018\u0010,\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u0010\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010/\u001a\u00020\u0004J\u001a\u00100\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00107\u001a\u00020+J\u0018\u00108\u001a\u00020\u001c2\b\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010:\u001a\u000205J\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u0004J\u0010\u0010=\u001a\u00020\u001c2\b\u0010>\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/liveperson/infra/preferences/PushMessagePreferences;", "", "()V", "KEY_AGENT_NAME", "", "KEY_AGENT_PID", "KEY_ALL_IDS", "KEY_BACKEND_SERVICE", "KEY_CLICKED_NOTIFICATION_ID", "KEY_COLLAPSE_KEY", "KEY_CONVERSATION_ID", "KEY_EVENT", "KEY_ID", "KEY_IS_OUTBOUND_CAMPAIGN", "KEY_IS_PUSH_NOTIFICATION_CLICKED", "KEY_LE_CAMPAIGN_ID", "KEY_LE_ENGAGEMENT_ID", "KEY_LOOK_BACK_PERIOD", "KEY_MESSAGE", "KEY_PUSH_TYPE", "KEY_TIME_CREATED", "KEY_TITLE", "KEY_TRANSACTION_ID", "LP_PUSH_MESSAGE_SHARED_PREF_FILENAME", "TAG", "preferences", "Landroid/content/SharedPreferences;", "addIdToSet", "", "id", "brandId", "cleanUp", "clearAll", "clearExpiredPushMessages", "clearPushMessage", "messageId", "generateKey", "msgId", "key", "getAllIds", "", "getBackendService", "getCachedPushMessage", "Lcom/liveperson/infra/model/PushMessage;", "getCachedPushWelcomeMessage", "getClickedNotificationId", "getLatestNotificationIdForBrand", "getPushPlatform", "getTransactionId", "init", "applicationContext", "Landroid/content/Context;", "isPushNotificationClicked", "", "setCachedPushMessage", "pushMessage", "setPushMessageClicked", "pushMessageId", "isClicked", "setPushPlatform", "pushType", "setSharedPreferencesDelegate", "preferencesDelegate", "infra_release"})
public final class PushMessagePreferences {
    @NotNull
    public static final PushMessagePreferences INSTANCE = new PushMessagePreferences();
    @NotNull
    private static final String TAG = "PushMessagePreferences";
    @NotNull
    private static final String KEY_ID = "id";
    @NotNull
    private static final String KEY_ALL_IDS = "all_ids";
    @NotNull
    private static final String KEY_TIME_CREATED = "time_created";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final String KEY_TITLE = "title";
    @NotNull
    private static final String KEY_AGENT_NAME = "agentName";
    @NotNull
    private static final String KEY_BACKEND_SERVICE = "backendService";
    @NotNull
    private static final String KEY_COLLAPSE_KEY = "collapse_key";
    @NotNull
    private static final String KEY_CONVERSATION_ID = "conversationId";
    @NotNull
    private static final String KEY_LE_ENGAGEMENT_ID = "leEngagementId";
    @NotNull
    private static final String KEY_LE_CAMPAIGN_ID = "leCampaignId";
    @NotNull
    private static final String KEY_IS_OUTBOUND_CAMPAIGN = "isOutboundCampaign";
    @NotNull
    private static final String KEY_LOOK_BACK_PERIOD = "lookBackPeriod";
    @NotNull
    private static final String KEY_AGENT_PID = "agentPid";
    @NotNull
    private static final String KEY_TRANSACTION_ID = "transactionId";
    @NotNull
    private static final String KEY_EVENT = "event";
    @NotNull
    private static final String LP_PUSH_MESSAGE_SHARED_PREF_FILENAME = "lp_push_message_shared_pref";
    @NotNull
    private static final String KEY_IS_PUSH_NOTIFICATION_CLICKED = "is_push_notification_clicked";
    @NotNull
    private static final String KEY_CLICKED_NOTIFICATION_ID = "clicked_notification_id";
    @NotNull
    private static final String KEY_PUSH_TYPE = "key_push_type";
    @Nullable
    private static SharedPreferences preferences;

    private PushMessagePreferences() {
    }

    public final void init(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (preferences == null) {
            preferences = applicationContext.getSharedPreferences(LP_PUSH_MESSAGE_SHARED_PREF_FILENAME, 0);
        }
    }

    public final void setCachedPushMessage(@NotNull String brandId, @NotNull PushMessage pushMessage) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)pushMessage, (String)"pushMessage");
        if (preferences == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "setCachedPushMessage: PushMessage preferences is not initialized");
            return;
        }
        SharedPreferences sharedPreferences = preferences;
        SharedPreferences.Editor editor = sharedPreferences != null ? sharedPreferences.edit() : null;
        String messageId = pushMessage.getPushMessageId();
        SharedPreferences.Editor editor2 = editor;
        if (editor2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor2.putString(this.generateKey(brandId, messageId, KEY_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, messageId));
        }
        SharedPreferences.Editor editor3 = editor;
        if (editor3 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            String string = this.generateKey(brandId, messageId, KEY_TIME_CREATED);
            Long l = pushMessage.getTimeCreated();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"pushMessage.timeCreated");
            editor3.putLong(string, ((Number)l).longValue());
        }
        SharedPreferences.Editor editor4 = editor;
        if (editor4 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor4.putString(this.generateKey(brandId, messageId, KEY_COLLAPSE_KEY), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getCollapseKey()));
        }
        SharedPreferences.Editor editor5 = editor;
        if (editor5 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor5.putString(this.generateKey(brandId, messageId, KEY_CONVERSATION_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getConversationId()));
        }
        SharedPreferences.Editor editor6 = editor;
        if (editor6 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor6.putString(this.generateKey(brandId, messageId, KEY_MESSAGE), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getMessage()));
        }
        SharedPreferences.Editor editor7 = editor;
        if (editor7 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor7.putString(this.generateKey(brandId, messageId, KEY_BACKEND_SERVICE), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getBackendService()));
        }
        SharedPreferences.Editor editor8 = editor;
        if (editor8 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor8.putString(this.generateKey(brandId, messageId, KEY_AGENT_NAME), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getFrom()));
        }
        SharedPreferences.Editor editor9 = editor;
        if (editor9 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor9.putString(this.generateKey(brandId, messageId, KEY_AGENT_PID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getAgentPid()));
        }
        SharedPreferences.Editor editor10 = editor;
        if (editor10 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor10.putString(this.generateKey(brandId, messageId, KEY_TRANSACTION_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getTransactionId()));
        }
        SharedPreferences.Editor editor11 = editor;
        if (editor11 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor11.putString(this.generateKey(brandId, messageId, KEY_TITLE), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getTitle()));
        }
        SharedPreferences.Editor editor12 = editor;
        if (editor12 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
            editor12.putString(this.generateKey(brandId, messageId, KEY_EVENT), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, pushMessage.getMessageEvent()));
        }
        if (pushMessage.getCampaignInfo() != null) {
            SharedPreferences.Editor editor13 = editor;
            if (editor13 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
                editor13.putString(this.generateKey(brandId, messageId, KEY_LE_ENGAGEMENT_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, String.valueOf(pushMessage.getCampaignInfo().getEngagementId())));
            }
            SharedPreferences.Editor editor14 = editor;
            if (editor14 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
                editor14.putString(this.generateKey(brandId, messageId, KEY_LE_CAMPAIGN_ID), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, String.valueOf(pushMessage.getCampaignInfo().getCampaignId())));
            }
            SharedPreferences.Editor editor15 = editor;
            if (editor15 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
                editor15.putBoolean(this.generateKey(brandId, messageId, KEY_IS_OUTBOUND_CAMPAIGN), pushMessage.getCampaignInfo().isOutboundCampaign());
            }
            SharedPreferences.Editor editor16 = editor;
            if (editor16 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
                String string = this.generateKey(brandId, messageId, KEY_LOOK_BACK_PERIOD);
                Long l = pushMessage.getLookBackPeriod();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"pushMessage.lookBackPeriod");
                editor16.putLong(string, ((Number)l).longValue());
            }
        }
        SharedPreferences.Editor editor17 = editor;
        if (editor17 != null) {
            editor17.apply();
        }
        Intrinsics.checkNotNullExpressionValue((Object)messageId, (String)"messageId");
        this.addIdToSet(messageId, brandId);
    }

    @Nullable
    public final PushMessage getCachedPushMessage(@NotNull String messageId, @NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        if (preferences == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "getCachedPushMessage: PushMessage preferences is not initialized");
            return null;
        }
        PushMessage pushMessage = null;
        SharedPreferences sharedPreferences = preferences;
        String message = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences != null ? sharedPreferences.getString(this.generateKey(brandId, messageId, KEY_MESSAGE), "") : null);
        CharSequence charSequence = message;
        if (!(charSequence == null || charSequence.length() == 0)) {
            SharedPreferences sharedPreferences2 = preferences;
            String agentName = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences2 != null ? sharedPreferences2.getString(this.generateKey(brandId, messageId, KEY_AGENT_NAME), "") : null);
            pushMessage = new PushMessage(brandId, agentName, message);
            SharedPreferences sharedPreferences3 = preferences;
            pushMessage.setBackendService(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences3 != null ? sharedPreferences3.getString(this.generateKey(brandId, messageId, KEY_BACKEND_SERVICE), "") : null));
            SharedPreferences sharedPreferences4 = preferences;
            pushMessage.setPushMessageId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences4 != null ? sharedPreferences4.getString(this.generateKey(brandId, messageId, KEY_ID), "") : null));
            SharedPreferences sharedPreferences5 = preferences;
            pushMessage.setTimeCreated(sharedPreferences5 != null ? Long.valueOf(sharedPreferences5.getLong(this.generateKey(brandId, messageId, KEY_TIME_CREATED), 0L)) : null);
            SharedPreferences sharedPreferences6 = preferences;
            pushMessage.setCollapseKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences6 != null ? sharedPreferences6.getString(this.generateKey(brandId, messageId, KEY_COLLAPSE_KEY), "") : null));
            SharedPreferences sharedPreferences7 = preferences;
            pushMessage.setConversationId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences7 != null ? sharedPreferences7.getString(this.generateKey(brandId, messageId, KEY_CONVERSATION_ID), "") : null));
            SharedPreferences sharedPreferences8 = preferences;
            pushMessage.setLookBackPeriod(sharedPreferences8 != null ? Long.valueOf(sharedPreferences8.getLong(this.generateKey(brandId, messageId, KEY_LOOK_BACK_PERIOD), -1L)) : null);
            SharedPreferences sharedPreferences9 = preferences;
            pushMessage.setAgentPid(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences9 != null ? sharedPreferences9.getString(this.generateKey(brandId, messageId, KEY_AGENT_PID), "") : null));
            SharedPreferences sharedPreferences10 = preferences;
            pushMessage.setTransactionId(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences10 != null ? sharedPreferences10.getString(this.generateKey(brandId, messageId, KEY_TRANSACTION_ID), "") : null));
            SharedPreferences sharedPreferences11 = preferences;
            String campaignId = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences11 != null ? sharedPreferences11.getString(this.generateKey(brandId, messageId, KEY_LE_CAMPAIGN_ID), "") : null);
            SharedPreferences sharedPreferences12 = preferences;
            String engagementId = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences12 != null ? sharedPreferences12.getString(this.generateKey(brandId, messageId, KEY_LE_ENGAGEMENT_ID), "") : null);
            SharedPreferences sharedPreferences13 = preferences;
            Boolean bl = sharedPreferences13 != null ? Boolean.valueOf(sharedPreferences13.getBoolean(this.generateKey(brandId, messageId, KEY_IS_OUTBOUND_CAMPAIGN), false)) : null;
            Intrinsics.checkNotNull(bl);
            boolean isOutboundCampaign = bl;
            Intrinsics.checkNotNullExpressionValue((Object)campaignId, (String)"campaignId");
            Long l = Long.parseLong(campaignId);
            Intrinsics.checkNotNullExpressionValue((Object)engagementId, (String)"engagementId");
            pushMessage.setCampaignInfo(new CampaignInfo(l, Long.parseLong(engagementId), isOutboundCampaign));
            SharedPreferences sharedPreferences14 = preferences;
            pushMessage.setTitle(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences14 != null ? sharedPreferences14.getString(this.generateKey(brandId, messageId, KEY_TITLE), "") : null));
            SharedPreferences sharedPreferences15 = preferences;
            pushMessage.setMessageEvent(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences15 != null ? sharedPreferences15.getString(this.generateKey(brandId, messageId, KEY_EVENT), "") : null));
        }
        return pushMessage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getCachedPushWelcomeMessage(@Nullable String messageId, @NotNull String brandId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string2;
            String string3 = messageId;
            if (string3 != null) {
                void it;
                String string4 = string3;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                String string5 = INSTANCE.generateKey(brandId, (String)it, KEY_MESSAGE);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string2 = string5;
            } else {
                string2 = null;
            }
            string = sharedPreferences.getString(string2, "");
        } else {
            string = null;
        }
        String string6 = DBEncryptionHelper.decrypt(encryptionVersion, string);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"decrypt(EncryptionVersio\u2026 it, KEY_MESSAGE) }, \"\"))");
        return string6;
    }

    public final void setPushMessageClicked(@Nullable String pushMessageId, boolean isClicked) {
        block4: {
            SharedPreferences.Editor editor;
            if (preferences == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000151, "setPushMessageClicked: PushMessage preferences is not initialized");
                return;
            }
            SharedPreferences sharedPreferences = preferences;
            SharedPreferences.Editor editor2 = editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            if (editor2 != null) {
                editor2.putBoolean(KEY_IS_PUSH_NOTIFICATION_CLICKED, isClicked);
            }
            CharSequence charSequence = pushMessageId;
            if (!(charSequence == null || charSequence.length() == 0)) {
                SharedPreferences.Editor editor3 = editor;
                if (editor3 != null) {
                    editor3.putString(KEY_CLICKED_NOTIFICATION_ID, pushMessageId);
                }
            }
            SharedPreferences.Editor editor4 = editor;
            if (editor4 == null) break block4;
            editor4.apply();
        }
    }

    public final boolean isPushNotificationClicked() {
        SharedPreferences sharedPreferences = preferences;
        return sharedPreferences != null ? sharedPreferences.getBoolean(KEY_IS_PUSH_NOTIFICATION_CLICKED, false) : false;
    }

    @Nullable
    public final String getClickedNotificationId() {
        Object object = preferences;
        if (object == null || (object = object.getString(KEY_CLICKED_NOTIFICATION_ID, "")) == null) {
            object = "";
        }
        Object id = object;
        LPLog.INSTANCE.d(TAG, "getClickedNotificationId: Clicked notification id: " + LPLog.INSTANCE.mask(id));
        return id;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getLatestNotificationIdForBrand(@NotNull String brandId) {
        Object v0;
        void $this$maxByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Set<String> allIds = this.getAllIds();
        if (allIds == null) return null;
        Sequence sequence = CollectionsKt.asSequence((Iterable)allIds);
        if (sequence == null) return null;
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<String, PushMessage>(brandId){
            final /* synthetic */ String $brandId;
            {
                this.$brandId = $brandId;
                super(1);
            }

            @Nullable
            public final PushMessage invoke(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return PushMessagePreferences.INSTANCE.getCachedPushMessage(id, this.$brandId);
            }
        }));
        if (sequence2 == null) return null;
        Sequence sequence3 = SequencesKt.filterNot((Sequence)sequence2, (Function1)getLatestNotificationIdForBrand.2.INSTANCE);
        if (sequence3 == null) return null;
        Sequence sequence4 = sequence3;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                PushMessage it = (PushMessage)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getTimeCreated();
                do {
                    Object e$iv = iterator$iv.next();
                    PushMessage it2 = (PushMessage)e$iv;
                    $i$a$-maxByOrNull-PushMessagePreferences$getLatestNotificationIdForBrand$3 = false;
                    Comparable v$iv = it2.getTimeCreated();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        PushMessage pushMessage = v0;
        if (pushMessage == null) return null;
        String string = pushMessage.getPushMessageId();
        return string;
    }

    public final void setPushPlatform(@NotNull String pushType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pushType, (String)"pushType");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putString(KEY_PUSH_TYPE, pushType)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @NotNull
    public final String getPushPlatform() {
        SharedPreferences sharedPreferences = preferences;
        String string = sharedPreferences != null ? sharedPreferences.getString(KEY_PUSH_TYPE, "") : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getBackendService(@Nullable String messageId, @NotNull String brandId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string2;
            String string3 = messageId;
            if (string3 != null) {
                void it;
                String string4 = string3;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                String string5 = INSTANCE.generateKey(brandId, (String)it, KEY_BACKEND_SERVICE);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string2 = string5;
            } else {
                string2 = null;
            }
            string = sharedPreferences.getString(string2, null);
        } else {
            string = null;
        }
        return DBEncryptionHelper.decrypt(encryptionVersion, string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getTransactionId(@Nullable String messageId, @NotNull String brandId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        EncryptionVersion encryptionVersion = EncryptionVersion.VERSION_1;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences != null) {
            String string2;
            String string3 = messageId;
            if (string3 != null) {
                void it;
                String string4 = string3;
                SharedPreferences sharedPreferences2 = sharedPreferences;
                EncryptionVersion encryptionVersion2 = encryptionVersion;
                boolean bl = false;
                String string5 = INSTANCE.generateKey(brandId, (String)it, KEY_TRANSACTION_ID);
                encryptionVersion = encryptionVersion2;
                sharedPreferences = sharedPreferences2;
                string2 = string5;
            } else {
                string2 = null;
            }
            string = sharedPreferences.getString(string2, null);
        } else {
            string = null;
        }
        return DBEncryptionHelper.decrypt(encryptionVersion, string);
    }

    private final void addIdToSet(String id, String brandId) {
        block1: {
            Set ids;
            block0: {
                SharedPreferences sharedPreferences = preferences;
                ids = sharedPreferences != null ? sharedPreferences.getStringSet(KEY_ALL_IDS, null) : null;
                LPLog.INSTANCE.d(TAG, "addIdToSet: Adding notification id: " + LPLog.INSTANCE.mask(id) + " into the list.");
                Collection collection = ids;
                if (!(collection == null || collection.isEmpty())) break block0;
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(id);
                SharedPreferences sharedPreferences2 = preferences;
                if (sharedPreferences2 == null || (sharedPreferences2 = sharedPreferences2.edit()) == null || (sharedPreferences2 = sharedPreferences2.putStringSet(KEY_ALL_IDS, (Set)newSet)) == null) break block1;
                sharedPreferences2.apply();
                break block1;
            }
            ids.add(id);
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putStringSet(KEY_ALL_IDS, ids)) == null) break block1;
            sharedPreferences.apply();
        }
    }

    private final Set<String> getAllIds() {
        SharedPreferences sharedPreferences = preferences;
        return sharedPreferences != null ? sharedPreferences.getStringSet(KEY_ALL_IDS, null) : null;
    }

    private final String generateKey(String brandId, String msgId, String key) {
        return key + "::" + msgId + "::" + brandId;
    }

    public final void clearPushMessage(@NotNull String brandId, @NotNull String messageId) {
        block0: {
            SharedPreferences.Editor editor;
            SharedPreferences.Editor editor2;
            SharedPreferences.Editor editor3;
            SharedPreferences.Editor editor4;
            SharedPreferences.Editor editor5;
            SharedPreferences.Editor editor6;
            SharedPreferences.Editor editor7;
            SharedPreferences.Editor editor8;
            SharedPreferences.Editor editor9;
            SharedPreferences.Editor editor10;
            SharedPreferences.Editor editor11;
            SharedPreferences.Editor editor12;
            SharedPreferences.Editor editor13;
            SharedPreferences.Editor editor14;
            SharedPreferences.Editor editor15;
            SharedPreferences.Editor editor16;
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
            LPLog.INSTANCE.d(TAG, "clearPushMessage: Clearing PushMessage with id: " + messageId + " from preferences");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (editor16 = sharedPreferences.edit()) == null || (editor15 = editor16.remove(this.generateKey(brandId, messageId, KEY_ID))) == null || (editor14 = editor15.remove(this.generateKey(brandId, messageId, KEY_TIME_CREATED))) == null || (editor13 = editor14.remove(this.generateKey(brandId, messageId, KEY_COLLAPSE_KEY))) == null || (editor12 = editor13.remove(this.generateKey(brandId, messageId, KEY_CONVERSATION_ID))) == null || (editor11 = editor12.remove(this.generateKey(brandId, messageId, KEY_MESSAGE))) == null || (editor10 = editor11.remove(this.generateKey(brandId, messageId, KEY_TITLE))) == null || (editor9 = editor10.remove(this.generateKey(brandId, messageId, KEY_AGENT_NAME))) == null || (editor8 = editor9.remove(this.generateKey(brandId, messageId, KEY_AGENT_PID))) == null || (editor7 = editor8.remove(this.generateKey(brandId, messageId, KEY_TRANSACTION_ID))) == null || (editor6 = editor7.remove(this.generateKey(brandId, messageId, KEY_EVENT))) == null || (editor5 = editor6.remove(this.generateKey(brandId, messageId, KEY_BACKEND_SERVICE))) == null || (editor4 = editor5.remove(this.generateKey(brandId, messageId, KEY_LE_ENGAGEMENT_ID))) == null || (editor3 = editor4.remove(this.generateKey(brandId, messageId, KEY_LE_CAMPAIGN_ID))) == null || (editor2 = editor3.remove(this.generateKey(brandId, messageId, KEY_IS_OUTBOUND_CAMPAIGN))) == null || (editor = editor2.remove(this.generateKey(brandId, messageId, KEY_LOOK_BACK_PERIOD))) == null) break block0;
            editor.apply();
        }
    }

    private final void clearExpiredPushMessages(String brandId) {
        block3: {
            Set<String> allIds = this.getAllIds();
            SharedPreferences sharedPreferences = preferences;
            SharedPreferences.Editor editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            LPLog.INSTANCE.d(TAG, "Stored Push Message Ids: " + LPLog.INSTANCE.mask(allIds));
            if (allIds == null) break block3;
            Iterator<String> iterator = allIds.iterator();
            while (iterator.hasNext()) {
                PushMessage pushMessage;
                String id = iterator.next();
                PushMessage pushMessage2 = pushMessage = this.getCachedPushMessage(id, brandId);
                boolean bl = pushMessage2 != null ? pushMessage2.isExpired() : false;
                if (!bl) continue;
                LPLog.INSTANCE.d(TAG, "clearExpiredPushMessages: Found expired push message in prefs. id: " + LPLog.INSTANCE.mask(id) + ". Removing related data.");
                this.clearPushMessage(brandId, id);
                iterator.remove();
            }
            SharedPreferences.Editor editor2 = editor;
            if (editor2 != null && (editor2 = editor2.putStringSet(KEY_ALL_IDS, allIds)) != null) {
                editor2.apply();
            }
            SharedPreferences.Editor editor3 = editor;
            if (editor3 != null) {
                editor3.apply();
            }
        }
    }

    public final void cleanUp(@NotNull String brandId) {
        block0: {
            SharedPreferences.Editor editor;
            SharedPreferences.Editor editor2;
            SharedPreferences.Editor editor3;
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            LPLog.INSTANCE.d(TAG, "cleanUp: Cleaning up PushMessage preferences.");
            this.clearExpiredPushMessages(brandId);
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (editor3 = sharedPreferences.edit()) == null || (editor2 = editor3.remove(KEY_IS_PUSH_NOTIFICATION_CLICKED)) == null || (editor = editor2.remove(KEY_CLICKED_NOTIFICATION_ID)) == null) break block0;
            editor.apply();
        }
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "clearAll: Clearing all data of PushMessage preferences");
            SharedPreferences sharedPreferences = preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    public final void setSharedPreferencesDelegate(@Nullable SharedPreferences preferencesDelegate) {
        preferences = preferencesDelegate;
    }
}

