/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.Bundle;
import android.speech.RecognitionListener;
import android.text.Editable;
import android.widget.EditText;
import com.liveperson.infra.utils.LPAudioUtils;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0012\u0010#\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0013H\u0016J\b\u0010*\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/liveperson/infra/utils/LpRecognitionListener;", "Landroid/speech/RecognitionListener;", "editText", "Landroid/widget/EditText;", "callback", "Lcom/liveperson/infra/utils/LPAudioUtils$SpeechRecognitionResultCallback;", "(Landroid/widget/EditText;Lcom/liveperson/infra/utils/LPAudioUtils$SpeechRecognitionResultCallback;)V", "getCallback", "()Lcom/liveperson/infra/utils/LPAudioUtils$SpeechRecognitionResultCallback;", "setCallback", "(Lcom/liveperson/infra/utils/LPAudioUtils$SpeechRecognitionResultCallback;)V", "speechInProgress", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "handleResult", "", "results", "Landroid/os/Bundle;", "onBeginningOfSpeech", "onBufferReceived", "buffer", "", "onEndOfSegmentedSession", "onEndOfSpeech", "onError", "error", "", "onEvent", "eventType", "params", "onLanguageDetection", "onPartialResults", "partialResults", "onReadyForSpeech", "onResults", "onRmsChanged", "rmsdB", "", "onSegmentResults", "segmentResults", "requestFocusOnTextInput", "Companion", "infra_release"})
public final class LpRecognitionListener
implements RecognitionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EditText editText;
    @NotNull
    private LPAudioUtils.SpeechRecognitionResultCallback callback;
    @NotNull
    private StringBuilder stringBuilder;
    private boolean speechInProgress;
    private static final float RMS_LEVEL_THRESHOLD = 8.0f;
    @NotNull
    public static final String TEXT_SOURCE_SPEECH_RECOGNITION = "TEXT_SOURCE_SPEECH_RECOGNITION";

    public LpRecognitionListener(@NotNull EditText editText, @NotNull LPAudioUtils.SpeechRecognitionResultCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.editText = editText;
        this.callback = callback2;
        this.stringBuilder = new StringBuilder();
    }

    @NotNull
    public final LPAudioUtils.SpeechRecognitionResultCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@NotNull LPAudioUtils.SpeechRecognitionResultCallback speechRecognitionResultCallback) {
        Intrinsics.checkNotNullParameter((Object)speechRecognitionResultCallback, (String)"<set-?>");
        this.callback = speechRecognitionResultCallback;
    }

    public void onReadyForSpeech(@Nullable Bundle params) {
    }

    public void onSegmentResults(@NotNull Bundle segmentResults) {
        Intrinsics.checkNotNullParameter((Object)segmentResults, (String)"segmentResults");
        this.handleResult(segmentResults);
    }

    public void onEndOfSegmentedSession() {
        this.callback.onStopListening();
    }

    public void onLanguageDetection(@NotNull Bundle results) {
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
    }

    public void onBeginningOfSpeech() {
        this.callback.refreshProgressBar();
        this.speechInProgress = true;
        StringsKt.clear((StringBuilder)this.stringBuilder);
        this.stringBuilder.append((CharSequence)this.editText.getText());
        Editable editable = this.editText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"editText.text");
        if (((CharSequence)editable).length() > 0) {
            this.stringBuilder.append(" ");
        }
        this.requestFocusOnTextInput();
    }

    public void onRmsChanged(float rmsdB) {
        if (this.speechInProgress && Float.compare(rmsdB, 8.0f) >= 0) {
            this.callback.refreshProgressBar();
        }
    }

    public void onBufferReceived(@Nullable byte[] buffer) {
    }

    public void onEndOfSpeech() {
        this.speechInProgress = false;
    }

    public void onError(int error) {
        this.callback.onStopListening();
        this.speechInProgress = false;
    }

    public void onResults(@NotNull Bundle results) {
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        this.handleResult(results);
        this.callback.onStopListening();
    }

    private final void handleResult(Bundle results) {
        ArrayList data = results.getStringArrayList("results_recognition");
        Collection collection = data;
        if (!(collection == null || collection.isEmpty())) {
            this.stringBuilder.append((String)data.get(0));
            this.editText.setTag((Object)TEXT_SOURCE_SPEECH_RECOGNITION);
            this.editText.setText((CharSequence)this.stringBuilder);
            this.requestFocusOnTextInput();
            this.editText.setTag(null);
        }
    }

    public void onPartialResults(@NotNull Bundle partialResults) {
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        ArrayList data = partialResults.getStringArrayList("results_recognition");
        Collection collection = data;
        if (!(collection == null || collection.isEmpty())) {
            this.editText.setTag((Object)TEXT_SOURCE_SPEECH_RECOGNITION);
            this.editText.setText((CharSequence)"");
            this.editText.append((CharSequence)this.stringBuilder);
            this.editText.append((CharSequence)data.get(0));
            this.requestFocusOnTextInput();
            this.editText.setTag(null);
        }
    }

    public void onEvent(int eventType, @Nullable Bundle params) {
    }

    private final void requestFocusOnTextInput() {
        this.editText.requestFocus();
        this.editText.setSelection(this.editText.length());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/utils/LpRecognitionListener$Companion;", "", "()V", "RMS_LEVEL_THRESHOLD", "", "TEXT_SOURCE_SPEECH_RECOGNITION", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

