package com.liveperson.infra.utils;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.liveperson.infra.Infra;

/**
 * This class gets the application context right before app <i>onCreate</i> event (bug fix for LE-85777).
 * <br/>
 * References:<br/>
 * <ul>
 * <li>Read <a href='https://firebase.googleblog.com/2016/12/how-does-firebase-initialize-on-android.html?m=1'>firebase blog: how does firebase initialize on android</a><br/></li>
 * <li><a href='https://youtu.be/AJqakuas_6g?t=20m38s'>The author explains in Google I/O</a></li>
 * </ul>
 */
public class LPInitProvider extends ContentProvider {
    @Override
    public boolean onCreate() {
        Context context = getContext();
        if (context != null) {
            Infra.instance.setContext(context);
        }

        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
