/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.controller.AndroidInterface;
import com.liveperson.infra.controller.CipherWrapper;
import com.liveperson.infra.controller.CipherWrapperFactory;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.AndroidFrameworkUtils;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 12\u00020\u0001:\u000201B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002J\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0010H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010)\u001a\u00020\u0010H\u0016J\u0012\u0010*\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u0010/\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/liveperson/infra/controller/DBEncryptionService;", "Lcom/liveperson/infra/Clearable;", "()V", "androidInterface", "Lcom/liveperson/infra/controller/AndroidInterface;", "androidKeyStore", "Ljava/security/KeyStore;", "cipherWrapperFactory", "Lcom/liveperson/infra/controller/CipherWrapperFactory;", "dbEncryptionKey", "Ljavax/crypto/SecretKey;", "legacyIvSpec", "Ljavax/crypto/spec/IvParameterSpec;", "onlyKeystore", "", "clear", "", "decrypt", "", "cipherText", "decryptKey", "encryptedKey", "decryptKeyWithCipher", "cipherWrapper", "Lcom/liveperson/infra/controller/CipherWrapper;", "encrypt", "plainText", "encryptAndSaveKey", "decryptedKey", "generateAesEncryptionKeyAndSave", "generateKeyPairInStoreIfNotExists", "getAESDecryptCipher", "apSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "getAESEncryptCipher", "getCipherForKey", "opMode", "", "initialize", "loadInternalLegacyAESKey", "loadLegacyIvSpec", "resetDBEncryptionService", "setDbEncryptionKey", "key", "unpackGCMSpecBytes", "Ljavax/crypto/spec/GCMParameterSpec;", "base64ivSpec", "unpackIvSpecBytes", "Android", "Companion", "infra_release"})
public class DBEncryptionService
implements Clearable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private KeyStore androidKeyStore;
    @Nullable
    private SecretKey dbEncryptionKey;
    @Nullable
    private IvParameterSpec legacyIvSpec;
    private boolean onlyKeystore;
    private CipherWrapperFactory cipherWrapperFactory;
    private AndroidInterface androidInterface;
    @NotNull
    private static final String TAG = "DBEncryptionService";
    @NotNull
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    @NotNull
    private static final String DB_ENCRYPTION_KEY = "dbEncryptionKey";
    @NotNull
    private static final String DB_ENCRYPTION_USES_KEYSTORE = "dbEncryptionUsesKeyStore";
    @NotNull
    private static final String ANDROID_INFRA_DB_ENC_KEY = "androidInfraDbEncKey";
    @NotNull
    private static final String DB_ENC_CN = "CN=DBKeyEncryptor, O=Liveperson";
    @NotNull
    private static final String MDNAME = "SHA-256";
    @NotNull
    private static final String MGFNAME = "MGF1";
    @NotNull
    private static final String MGFSPEC_MDNAME = "SHA-1";
    private static final int ANDROID_INFRA_DB_ENC_KEY_SIZE = 256;
    @NotNull
    private static final String TRANSFORMATION_RSA_18_PLUS = "RSA/ECB/PKCS1Padding";
    @NotNull
    private static final String TRANSFORMATION_RSA_23_PLUS = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    @NotNull
    private static final String TRANSFORMATION_AES_GCM_NoPadding = "AES/GCM/NoPadding";
    @NotNull
    private static final String TRANSFORMATION_AES_PKCS5Padding = "AES/CBC/PKCS5Padding";
    @NotNull
    private static final String TRANSFORMATION_AES_PKCS7Padding = "AES/CBC/PKCS7Padding";
    @NotNull
    private static final String INITIALIZATION_VECTOR = "initializationVector";
    @NotNull
    private static final String IV_SEPARATOR = "::";
    private static int encryptAttempts;

    public DBEncryptionService() {
        this.initialize();
    }

    public void initialize() {
        if (this.androidInterface == null) {
            this.androidInterface = new Android();
        }
        this.onlyKeystore = Build.VERSION.SDK_INT >= 23 && !PreferenceManager.getInstance().contains(DB_ENCRYPTION_KEY, "appLevelPreferences");
        LPLog.INSTANCE.i(TAG, "Using " + (this.onlyKeystore ? "Keystore" : "Legacy") + " encryption system.");
        AndroidInterface androidInterface = this.androidInterface;
        if (androidInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
            androidInterface = null;
        }
        androidInterface.loadKeystore();
        this.legacyIvSpec = this.loadLegacyIvSpec();
        if (this.cipherWrapperFactory == null) {
            this.cipherWrapperFactory = new CipherWrapperFactory();
        }
        if (this.onlyKeystore) {
            this.dbEncryptionKey = null;
        } else {
            this.setDbEncryptionKey(this.loadInternalLegacyAESKey());
        }
    }

    private final IvParameterSpec loadLegacyIvSpec() {
        String initializationVectorFromSharedPrefs = PreferenceManager.getInstance().getStringValue(INITIALIZATION_VECTOR, "appLevelPreferences", null);
        if (initializationVectorFromSharedPrefs != null) {
            LPLog.INSTANCE.w(TAG, "Found a legacy Initialization Vector; loading it. Please log out and back in to clear old data.");
            return new IvParameterSpec(Base64.decode((String)initializationVectorFromSharedPrefs, (int)0));
        }
        return null;
    }

    private final IvParameterSpec unpackIvSpecBytes(String base64ivSpec) {
        return new IvParameterSpec(Base64.decode((String)base64ivSpec, (int)0));
    }

    private final GCMParameterSpec unpackGCMSpecBytes(String base64ivSpec) {
        return new GCMParameterSpec(128, Base64.decode((String)base64ivSpec, (int)0));
    }

    private final String loadInternalLegacyAESKey() {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        String encryptionKey = null;
        String encryptedEncryptionKeyFromSharedPrefs = PreferenceManager.getInstance().getStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", null);
        try {
            AndroidInterface androidInterface = this.androidInterface;
            if (androidInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            privateKeyEntry = androidInterface.getKeystoreEntry();
        }
        catch (Exception e) {
            privateKeyEntry = null;
        }
        KeyStore.PrivateKeyEntry privateKeyEntryForValidation = privateKeyEntry;
        if (encryptedEncryptionKeyFromSharedPrefs == null || privateKeyEntryForValidation == null) {
            encryptionKey = this.generateAesEncryptionKeyAndSave();
        } else if (PreferenceManager.getInstance().getBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", false)) {
            encryptionKey = this.decryptKey(encryptedEncryptionKeyFromSharedPrefs);
        } else {
            encryptionKey = encryptedEncryptionKeyFromSharedPrefs;
            this.encryptAndSaveKey(encryptionKey);
        }
        return encryptionKey;
    }

    private final String generateAesEncryptionKeyAndSave() {
        AndroidInterface androidInterface = this.androidInterface;
        if (androidInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
            androidInterface = null;
        }
        String encryptionKey = androidInterface.generateLegacyAesEncryptionKey();
        this.encryptAndSaveKey(encryptionKey);
        return encryptionKey;
    }

    private final CipherWrapper getCipherForKey(int opMode) {
        CipherWrapper resultCipher = null;
        Key key = null;
        if (opMode == 1) {
            AndroidInterface androidInterface = this.androidInterface;
            if (androidInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            key = androidInterface.getPublicKey();
        }
        if (opMode == 2) {
            AndroidInterface androidInterface = this.androidInterface;
            if (androidInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            key = androidInterface.getKeystoreEntry().getPrivateKey();
        }
        if (AndroidFrameworkUtils.getSdkVersion() >= 23) {
            OAEPParameterSpec spec = new OAEPParameterSpec(MDNAME, MGFNAME, new MGF1ParameterSpec(MGFSPEC_MDNAME), PSource.PSpecified.DEFAULT);
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            Key key2 = key;
            if (key2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            resultCipher = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_RSA_23_PLUS, opMode, key2, spec);
        } else {
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            Key key3 = key;
            if (key3 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            resultCipher = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_RSA_18_PLUS, opMode, key3);
        }
        return resultCipher;
    }

    private final String decryptKey(String encryptedKey) {
        String decryptedKey = null;
        try {
            CipherWrapper output = this.getCipherForKey(2);
            decryptedKey = this.decryptKeyWithCipher(encryptedKey, output);
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000035, "IOException while decrypting key. Android SDK Version: " + Build.VERSION.SDK_INT, e);
            try {
                LPLog.INSTANCE.w(TAG, "fallback: use old RSA algorithm - RSA/ECB/PKCS1Padding, to decrypt key in sharedPref");
                AndroidInterface androidInterface = this.androidInterface;
                if (androidInterface == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                    androidInterface = null;
                }
                KeyStore.PrivateKeyEntry privateKeyEntry = androidInterface.getKeystoreEntry();
                CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
                if (cipherWrapperFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                    cipherWrapperFactory = null;
                }
                CipherWrapper cipher = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_RSA_18_PLUS, 2, privateKeyEntry.getPrivateKey());
                decryptedKey = this.decryptKeyWithCipher(encryptedKey, cipher);
                if (AndroidFrameworkUtils.getSdkVersion() >= 23 && PreferenceManager.getInstance().contains(DB_ENCRYPTION_KEY, "appLevelPreferences")) {
                    LPLog.INSTANCE.d(TAG, "set flag to reset DBEncryptionService");
                    PreferenceManager.getInstance().setBooleanValue("RESET_DB_ENCRYPTION_SERVICE_KEY", "appLevelPreferences", true);
                }
                LPLog.INSTANCE.d(TAG, "Got decrypted key by using old RSA algorithm");
            }
            catch (Exception e2) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000035, "Exception while decrypting key - fallback", e2);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000035, "Exception while decrypting key.", e);
        }
        return decryptedKey;
    }

    private final String decryptKeyWithCipher(String encryptedKey, CipherWrapper cipherWrapper) {
        CipherInputStream cipherInputStream = cipherWrapper.createCipherInputStream(encryptedKey);
        ArrayList<Byte> values = new ArrayList<Byte>();
        int nextByte = 0;
        while (true) {
            int n;
            int it = n = cipherInputStream.read();
            boolean bl = false;
            nextByte = it;
            if (n == -1) break;
            values.add((byte)nextByte);
        }
        byte[] bytes = new byte[values.size()];
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            Object e = values.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"values[i]");
            bytes[i] = ((Number)e).byteValue();
        }
        int n2 = 0;
        n = bytes.length;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, n2, n, charset2);
    }

    public void resetDBEncryptionService() {
        LPLog.INSTANCE.d(TAG, "resetDBEncryptionService");
        this.onlyKeystore = true;
        this.dbEncryptionKey = null;
        this.legacyIvSpec = null;
        AndroidInterface androidInterface = this.androidInterface;
        if (androidInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
            androidInterface = null;
        }
        androidInterface.clear();
        PreferenceManager.getInstance().remove(DB_ENCRYPTION_KEY, "appLevelPreferences");
        PreferenceManager.getInstance().remove(INITIALIZATION_VECTOR, "appLevelPreferences");
    }

    private final void encryptAndSaveKey(String decryptedKey) {
        String encryptedKey = null;
        boolean usesAndroidKeyStore = true;
        this.generateKeyPairInStoreIfNotExists();
        try {
            CipherWrapper input = this.getCipherForKey(1);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = input.createCipherOutputStream(outputStream);
            String string = decryptedKey;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            cipherOutputStream.write(byArray);
            cipherOutputStream.close();
            encryptedKey = Base64.encodeToString((byte[])outputStream.toByteArray(), (int)0);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000036, "Exception while encrypting/saving key.", e);
            encryptedKey = decryptedKey;
            usesAndroidKeyStore = false;
        }
        PreferenceManager.getInstance().setStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", encryptedKey);
        PreferenceManager.getInstance().setBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", usesAndroidKeyStore);
    }

    private final void generateKeyPairInStoreIfNotExists() {
        try {
            AndroidInterface androidInterface = this.androidInterface;
            if (androidInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            if (!androidInterface.keystoreContainsAlias(ANDROID_INFRA_DB_ENC_KEY)) {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                end.add(1, 120);
                AndroidInterface androidInterface2 = this.androidInterface;
                if (androidInterface2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                    androidInterface2 = null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                Intrinsics.checkNotNullExpressionValue((Object)end, (String)"end");
                KeyPairGenerator generator = androidInterface2.initKeyPairGenerator(start, end);
                generator.generateKeyPair();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000038, "Exception while generating KeyPair.", e);
        }
    }

    private final void setDbEncryptionKey(String key) {
        CharSequence charSequence = key;
        if (charSequence == null || charSequence.length() == 0) {
            LPLog.INSTANCE.d(TAG, "setDbEncryptionKey - key is NullOrEmpty");
            return;
        }
        byte[] decodedKey = Base64.decode((String)key, (int)0);
        byte by = decodedKey[0];
        decodedKey[0] = (byte)(by + 1);
        this.dbEncryptionKey = new SecretKeySpec(decodedKey, "AES");
    }

    @Nullable
    public String encrypt(@Nullable String plainText) {
        block6: {
            LPLog.INSTANCE.d(TAG, "encrypt()");
            if (TextUtils.isEmpty((CharSequence)plainText)) {
                return plainText;
            }
            try {
                CipherWrapper cipher = this.getAESEncryptCipher();
                String string = plainText;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] encryptedBytes = cipher.doFinal(byArray);
                byte[] iv = cipher.iv();
                String base64Bytes = Base64.encodeToString((byte[])encryptedBytes, (int)0);
                String base64iv = Base64.encodeToString((byte[])iv, (int)0);
                LPLog.INSTANCE.v(TAG, "Successfully Encrypted block " + LPLog.INSTANCE.mask(base64iv));
                encryptAttempts = 0;
                return base64iv + IV_SEPARATOR + base64Bytes;
            }
            catch (InvalidKeyException e) {
                LPLog.INSTANCE.w(TAG, "InvalidKeyException " + e);
                if (Build.VERSION.SDK_INT < 23 || !(e.getCause() instanceof KeyPermanentlyInvalidatedException)) break block6;
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000039, "KeyPermanentlyInvalidatedException while Encrypting text.", e);
                KeyStore keyStore = this.androidKeyStore;
                if (keyStore == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                    keyStore = null;
                }
                keyStore.deleteEntry(ANDROID_INFRA_DB_ENC_KEY);
                if (encryptAttempts == 0) {
                    int n = encryptAttempts;
                    encryptAttempts = n + 1;
                    this.encrypt(plainText);
                }
                return plainText;
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000039, "Exception while Encrypting text.", e);
            }
        }
        return plainText;
    }

    @Nullable
    public String decrypt(@Nullable String cipherText) {
        LPLog.INSTANCE.d(TAG, "decrypt() " + cipherText);
        if (TextUtils.isEmpty((CharSequence)cipherText)) {
            return cipherText;
        }
        String string = cipherText;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        Regex regex = new Regex(IV_SEPARATOR);
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray;
        GCMParameterSpec gcmParameterSpec = null;
        String messageText = null;
        if (parts.length <= 1) {
            LPLog.INSTANCE.w(TAG, "decrypt failure. No gcmParameterSpec.");
            return cipherText;
        }
        gcmParameterSpec = this.unpackGCMSpecBytes(parts[0]);
        messageText = parts[1];
        try {
            CipherWrapper cipherWrapper = this.getAESDecryptCipher(gcmParameterSpec);
            byte[] data = Base64.decode((String)messageText, (int)0);
            byte[] decryptedBytes = cipherWrapper.doFinal(data);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String res = new String(decryptedBytes, charset2);
            LPLog.INSTANCE.v(TAG, "Successfully Decrypted " + (parts.length > 1 ? LPLog.INSTANCE.mask("block " + parts[0] + "\nres = " + res) : "Legacy block"));
            return res;
        }
        catch (InvalidAlgorithmParameterException e) {
            LPLog.INSTANCE.w(TAG, FlowTags.DECRYPTION, "InvalidAlgorithmParameterException " + cipherText);
            return null;
        }
        catch (BadPaddingException badPaddingException) {
            LPLog.INSTANCE.w(TAG, FlowTags.DECRYPTION, "Caught a bad padding exception!", badPaddingException);
            LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "Using fallback after BadPaddingException");
            try {
                CipherWrapper cipher = this.getAESDecryptCipher(gcmParameterSpec);
                byte[] data = Utils.hexStringToByteArray(messageText);
                byte[] decryptedBytes = cipher.doFinal(data);
                LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "BadPaddingException fallback worked!");
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset3 = charset;
                return new String(decryptedBytes, charset3);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, ErrorCode.ERR_0000003A, "BadPaddingException fallback failed.", e);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, ErrorCode.ERR_0000003B, "Caught an unexpected exception.", e);
        }
        return cipherText;
    }

    @Override
    public void clear() {
        LPLog.INSTANCE.d(TAG, "clear()");
        AndroidInterface androidInterface = this.androidInterface;
        if (androidInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
            androidInterface = null;
        }
        androidInterface.clear();
    }

    private final CipherWrapper getAESEncryptCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, UnrecoverableEntryException, KeyStoreException, InvalidAlgorithmParameterException, InvalidKeyException {
        CipherWrapper cipherWrapper = null;
        if (this.cipherWrapperFactory == null) {
            this.cipherWrapperFactory = new CipherWrapperFactory();
        }
        if (this.onlyKeystore) {
            AndroidInterface androidInterface;
            AndroidInterface androidInterface2 = this.androidInterface;
            if (androidInterface2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface2 = null;
            }
            androidInterface2.createKeystoreAESKeyIfNecessary();
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            if ((androidInterface = this.androidInterface) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            cipherWrapper = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_AES_GCM_NoPadding, 1, androidInterface.secretKey());
        } else {
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            cipherWrapper = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_AES_GCM_NoPadding, 1, this.dbEncryptionKey, this.legacyIvSpec);
        }
        CipherWrapper cipherWrapper2 = cipherWrapper;
        if (cipherWrapper2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return cipherWrapper2;
    }

    private final CipherWrapper getAESDecryptCipher(AlgorithmParameterSpec apSpec) throws NoSuchAlgorithmException, NoSuchPaddingException, UnrecoverableEntryException, KeyStoreException, InvalidAlgorithmParameterException, InvalidKeyException {
        CipherWrapper cipherWrapper = null;
        if (this.onlyKeystore) {
            AndroidInterface androidInterface;
            AndroidInterface androidInterface2 = this.androidInterface;
            if (androidInterface2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface2 = null;
            }
            androidInterface2.createKeystoreAESKeyIfNecessary();
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            if ((androidInterface = this.androidInterface) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                androidInterface = null;
            }
            AlgorithmParameterSpec algorithmParameterSpec = apSpec;
            if (algorithmParameterSpec == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            cipherWrapper = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_AES_GCM_NoPadding, 2, androidInterface.secretKey(), algorithmParameterSpec);
        } else {
            CipherWrapperFactory cipherWrapperFactory = this.cipherWrapperFactory;
            if (cipherWrapperFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cipherWrapperFactory");
                cipherWrapperFactory = null;
            }
            AlgorithmParameterSpec algorithmParameterSpec = apSpec;
            if (algorithmParameterSpec == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            cipherWrapper = cipherWrapperFactory.createCipherWrapper(TRANSFORMATION_AES_GCM_NoPadding, 2, this.dbEncryptionKey, algorithmParameterSpec);
        }
        return cipherWrapper;
    }

    @NotNull
    public static final EncryptionVersion getAppEncryptionVersion() {
        return Companion.getAppEncryptionVersion();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00178FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/infra/controller/DBEncryptionService$Companion;", "", "()V", "ANDROID_INFRA_DB_ENC_KEY", "", "ANDROID_INFRA_DB_ENC_KEY_SIZE", "", "ANDROID_KEYSTORE", "DB_ENCRYPTION_KEY", "DB_ENCRYPTION_USES_KEYSTORE", "DB_ENC_CN", "INITIALIZATION_VECTOR", "IV_SEPARATOR", "MDNAME", "MGFNAME", "MGFSPEC_MDNAME", "TAG", "TRANSFORMATION_AES_GCM_NoPadding", "TRANSFORMATION_AES_PKCS5Padding", "TRANSFORMATION_AES_PKCS7Padding", "TRANSFORMATION_RSA_18_PLUS", "TRANSFORMATION_RSA_23_PLUS", "appEncryptionVersion", "Lcom/liveperson/infra/utils/EncryptionVersion;", "getAppEncryptionVersion$annotations", "getAppEncryptionVersion", "()Lcom/liveperson/infra/utils/EncryptionVersion;", "encryptAttempts", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EncryptionVersion getAppEncryptionVersion() {
            EncryptionVersion encryptionVersion;
            try {
                EncryptionVersion encryptionVersion2 = EncryptionVersion.fromInt(Configuration.getInteger(R.integer.encryptionVersion));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)encryptionVersion2), (String)"{\n\t\t\t\tEncryptionVersion.\u2026.encryptionVersion))\n\t\t\t}");
                encryptionVersion = encryptionVersion2;
            }
            catch (Resources.NotFoundException e) {
                LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_0000003C, "Exception while getting app encryption version.", e);
                encryptionVersion = EncryptionVersion.VERSION_1;
            }
            return encryptionVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getAppEncryptionVersion$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0017J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/infra/controller/DBEncryptionService$Android;", "Lcom/liveperson/infra/controller/AndroidInterface;", "(Lcom/liveperson/infra/controller/DBEncryptionService;)V", "keyStoreSecretKey", "Ljavax/crypto/SecretKey;", "getKeyStoreSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey", "getSecretKey", "clear", "", "createKeystoreAESKeyIfNecessary", "generateLegacyAesEncryptionKey", "", "getKeystoreEntry", "Ljava/security/KeyStore$PrivateKeyEntry;", "getPublicKey", "Ljava/security/PublicKey;", "initKeyPairGenerator", "Ljava/security/KeyPairGenerator;", "start", "Ljava/util/Calendar;", "end", "keystoreContainsAlias", "", "alias", "loadKeystore", "refreshKey", "infra_release"})
    public class Android
    implements AndroidInterface {
        @Nullable
        private SecretKey secretKey;

        @NotNull
        public final SecretKey getKeyStoreSecretKey() {
            KeyStore.Entry keyEntry;
            KeyStore keyStore = DBEncryptionService.this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                keyStore = null;
            }
            KeyStore.Entry entry = keyEntry = keyStore.getEntry(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            }
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"keyEntry as KeyStore.SecretKeyEntry).secretKey");
            return secretKey;
        }

        private final SecretKey getSecretKey() {
            return this.secretKey != null ? this.secretKey : this.getKeyStoreSecretKey();
        }

        @Override
        @TargetApi(value=23)
        public void createKeystoreAESKeyIfNecessary() {
            try {
                AndroidInterface androidInterface = DBEncryptionService.this.androidInterface;
                if (androidInterface == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                    androidInterface = null;
                }
                if (!androidInterface.keystoreContainsAlias(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY)) {
                    try {
                        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", DBEncryptionService.ANDROID_KEYSTORE);
                        String[] stringArray = new String[]{"GCM"};
                        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY, 3).setKeySize(256).setBlockModes(stringArray);
                        stringArray = new String[]{"NoPadding"};
                        KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).build();
                        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"Builder(\n\t\t\t\t\t\t\tANDROID_\u2026ING_NONE)\n\t\t\t\t\t\t\t.build()");
                        KeyGenParameterSpec keyGenParameterSpec2 = keyGenParameterSpec;
                        keyGenerator.init((AlgorithmParameterSpec)keyGenParameterSpec2);
                        keyGenerator.generateKey();
                        AndroidInterface androidInterface2 = DBEncryptionService.this.androidInterface;
                        if (androidInterface2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"androidInterface");
                            androidInterface2 = null;
                        }
                        androidInterface2.refreshKey();
                    }
                    catch (Exception e) {
                        LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_0000014B, "Fatal exception while generating new AES key: ", e);
                    }
                }
            }
            catch (KeyStoreException e) {
                LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_0000014A, "Fatal exception while accessing keystore: ", e);
            }
        }

        @Override
        @NotNull
        public String generateLegacyAesEncryptionKey() {
            SecretKey secretKey;
            try {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(256);
                SecretKey secretKey2 = keyGen.generateKey();
                Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"{\n\t\t\t\tval keyGen = KeyGe\u2026eyGen.generateKey()\n\n\t\t\t}");
                secretKey = secretKey2;
            }
            catch (NoSuchAlgorithmException noSuchAlgException) {
                LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_00000037, "Exception while generating AES Encryption Key", noSuchAlgException);
                byte[] randomBytes = new byte[32];
                new SecureRandom().nextBytes(randomBytes);
                String string = Base64.encodeToString((byte[])randomBytes, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(randomBytes, Base64.DEFAULT)");
                return string;
            }
            SecretKey secretKey3 = secretKey;
            String string = Base64.encodeToString((byte[])secretKey3.getEncoded(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(secretKey.encoded, Base64.DEFAULT)");
            return string;
        }

        @Override
        public boolean keystoreContainsAlias(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            KeyStore keyStore = DBEncryptionService.this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                keyStore = null;
            }
            return keyStore.containsAlias(alias);
        }

        @Override
        @NotNull
        public KeyPairGenerator initKeyPairGenerator(@NotNull Calendar start, @NotNull Calendar end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", DBEncryptionService.ANDROID_KEYSTORE);
            KeyGenParameterSpec keyGenParameterSpec = null;
            if (Build.VERSION.SDK_INT >= 23) {
                KeyGenParameterSpec keyGenParameterSpec2 = new KeyGenParameterSpec.Builder(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY, 3).setCertificateSubject(new X500Principal(DBEncryptionService.DB_ENC_CN)).setCertificateSerialNumber(BigInteger.ONE).setKeyValidityStart(start.getTime()).setKeyValidityEnd(end.getTime()).build();
                Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec2, (String)"Builder(ANDROID_INFRA_DB\u2026d(end.time)\n\t\t\t\t\t.build()");
                keyGenParameterSpec = keyGenParameterSpec2;
                generator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
            } else {
                generator.initialize((AlgorithmParameterSpec)new KeyPairGeneratorSpec.Builder(Infra.instance.getApplicationContext()).setAlias(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY).setSubject(new X500Principal(DBEncryptionService.DB_ENC_CN)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build());
            }
            Intrinsics.checkNotNullExpressionValue((Object)generator, (String)"generator");
            return generator;
        }

        @Override
        @NotNull
        public KeyStore.PrivateKeyEntry getKeystoreEntry() throws IOException {
            KeyStore keyStore = DBEncryptionService.this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                keyStore = null;
            }
            KeyStore.Entry entry = keyStore.getEntry(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
            }
            return (KeyStore.PrivateKeyEntry)entry;
        }

        @Override
        public void loadKeystore() {
            try {
                KeyStore keyStore = KeyStore.getInstance(DBEncryptionService.ANDROID_KEYSTORE);
                Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"getInstance(\"AndroidKeyStore\")");
                DBEncryptionService.this.androidKeyStore = keyStore;
                KeyStore keyStore2 = DBEncryptionService.this.androidKeyStore;
                if (keyStore2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                    keyStore2 = null;
                }
                keyStore2.load(null, null);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_00000034, "Failed to load Keystore.", e);
            }
        }

        @Override
        @Nullable
        public SecretKey secretKey() {
            return this.getSecretKey();
        }

        @Override
        public void refreshKey() {
            this.secretKey = this.getKeyStoreSecretKey();
        }

        @Override
        @NotNull
        public PublicKey getPublicKey() {
            PublicKey publicKey = this.getKeystoreEntry().getCertificate().getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getKeystoreEntry().certificate.publicKey");
            return publicKey;
        }

        @Override
        public void clear() {
            try {
                KeyStore keyStore = DBEncryptionService.this.androidKeyStore;
                if (keyStore == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
                    keyStore = null;
                }
                keyStore.deleteEntry(DBEncryptionService.ANDROID_INFRA_DB_ENC_KEY);
                LPLog.INSTANCE.d(DBEncryptionService.TAG, "clear succeed");
            }
            catch (Exception kse) {
                LPLog.INSTANCE.d(DBEncryptionService.TAG, "exception deleting key store entry: ", kse);
            }
        }
    }
}

