/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.loggos;

import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.analytics.EventProperty;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.log.LogLine;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/loggos/LoggosMessageFactory;", "", "accountId", "", "(Ljava/lang/String;)V", "convertToJson", "Lorg/json/JSONObject;", "logLine", "Lcom/liveperson/infra/log/LogLine;", "parseAnalyticsData", "userProperties", "Ljava/util/HashMap;", "analyticsEvent", "Lcom/liveperson/infra/analytics/AnalyticsEvent;", "parseAnalyticsEvent", "Companion", "infra_release"})
public final class LoggosMessageFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private static final String TAG = "LoggosMessage";
    @NotNull
    private static final String LOGGOS_CONTEXT = "context";
    @NotNull
    private static final String LOGGOS_ANDROID_CONTEXT = "AndroidSdk";
    @NotNull
    private static final String SDK_VERSION = "integrationVersion";
    @NotNull
    private static final String ACCOUNT_ID = "accountId";
    @NotNull
    private static final String TIME = "time";
    @NotNull
    private static final String FILENAME = "filename";
    @NotNull
    private static final String LOG_LEVEL = "logLevel";
    @NotNull
    private static final String INFO = "info";
    @NotNull
    private static final String ERROR = "error";
    @NotNull
    private static final String ERROR_MESSAGE = "error_message";
    @NotNull
    private static final String TITLE = "title";
    @NotNull
    private static final String MESSAGE = "msg";
    @NotNull
    private static final String UUID = "uid";
    @NotNull
    private static final String EVENT = "event";
    @NotNull
    private static final String EVENT_NAME = "event_name";
    @NotNull
    private static final String EVENT_PROPERTIES = "event_properties";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String PROPERTY_NAME = "name";
    @NotNull
    private static final String PROPERTY_VALUE = "value";
    @NotNull
    private static final String TIMESTAMP_FORMAT = "yyyy-mm-dd HH:MM:SS,SSS";

    public LoggosMessageFactory(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)ACCOUNT_ID);
        this.accountId = accountId;
    }

    @NotNull
    public final JSONObject convertToJson(@NotNull LogLine logLine) {
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(LOGGOS_CONTEXT, (Object)LOGGOS_ANDROID_CONTEXT);
            jsonObject.put(SDK_VERSION, (Object)"5.23.0-beta01");
            jsonObject.put(ACCOUNT_ID, (Object)this.accountId);
            jsonObject.put(TIME, (Object)new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).format(logLine.getTime()));
            jsonObject.put(FILENAME, (Object)logLine.getTag());
            jsonObject.put(LOG_LEVEL, (Object)logLine.getLevel().getApiName());
            jsonObject.put(TITLE, (Object)logLine.getMessage());
            jsonObject.put(MESSAGE, (Object)logLine.toString());
            jsonObject.put(UUID, (Object)java.util.UUID.randomUUID().toString());
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "Exception when serializing Logs to LoggosMessages", e);
        }
        return jsonObject;
    }

    @NotNull
    public final JSONObject parseAnalyticsData(@NotNull HashMap<String, Object> userProperties, @NotNull AnalyticsEvent analyticsEvent) {
        Intrinsics.checkNotNullParameter(userProperties, (String)"userProperties");
        Intrinsics.checkNotNullParameter((Object)analyticsEvent, (String)"analyticsEvent");
        JSONObject analyticsData = new JSONObject();
        String logType = INFO;
        analyticsData.put(LOGGOS_CONTEXT, (Object)LOGGOS_ANDROID_CONTEXT);
        String errorMessage = analyticsEvent.getError();
        CharSequence charSequence = errorMessage;
        if (!(charSequence == null || charSequence.length() == 0)) {
            analyticsData.put(ERROR_MESSAGE, (Object)errorMessage);
            logType = ERROR;
        }
        analyticsData.put(LOG_LEVEL, (Object)logType);
        for (Map.Entry entry : ((Map)userProperties).entrySet()) {
            analyticsData.put((String)entry.getKey(), entry.getValue());
        }
        JSONObject analyticsEventsJson = this.parseAnalyticsEvent(analyticsEvent);
        analyticsData.put(EVENT, analyticsEvent.getEventName());
        analyticsData.put(EVENT_PROPERTIES, (Object)analyticsEventsJson);
        return analyticsData;
    }

    private final JSONObject parseAnalyticsEvent(AnalyticsEvent analyticsEvent) {
        JSONObject eventObject = new JSONObject();
        try {
            JSONArray properties = new JSONArray();
            eventObject.put(EVENT_NAME, analyticsEvent.getEventName());
            for (EventProperty property : analyticsEvent.getEventProperties()) {
                JSONObject prop = new JSONObject().put(PROPERTY_NAME, (Object)property.getPropertyName()).put(PROPERTY_VALUE, property.getPropertyValue());
                properties.put((Object)prop);
            }
            eventObject.put(PROPERTIES, (Object)properties);
        }
        catch (Exception exception) {
            LPLog.INSTANCE.w(TAG, "Exception when serializing LPEvents to LoggosMessages", exception);
        }
        return eventObject;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/liveperson/infra/loggos/LoggosMessageFactory$Companion;", "", "()V", "ACCOUNT_ID", "", "ERROR", "ERROR_MESSAGE", "EVENT", "EVENT_NAME", "EVENT_PROPERTIES", "FILENAME", "INFO", "LOGGOS_ANDROID_CONTEXT", "LOGGOS_CONTEXT", "LOG_LEVEL", "MESSAGE", "PROPERTIES", "PROPERTY_NAME", "PROPERTY_VALUE", "SDK_VERSION", "TAG", "TIME", "TIMESTAMP_FORMAT", "TITLE", "UUID", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

