/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.otel;

import android.os.Build;
import com.liveperson.infra.otel.LPTelemetryAttributeKey;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceSpanCollector;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.otel.OtelUtils;
import com.liveperson.infra.otel.exporters.OtlpExporter;
import com.liveperson.infra.otel.exporters.OtlpHttpExporter;
import com.liveperson.infra.otel.models.OtlpAttribute;
import com.liveperson.infra.otel.models.OtlpResource;
import com.liveperson.infra.otel.models.OtlpValueData;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006J\u0010\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u0018J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/liveperson/infra/otel/LPTelemetryManager;", "", "()V", "AUTO_EXPORT_THRESHOLD", "", "DEFAULT_OTEL_DOMAIN", "", "OTLP_COLLECTOR_ENDPOINT_FORMAT", "RANDOM_SAMPLING_RATE", "TAG", "activeCollector", "Lcom/liveperson/infra/otel/LPTraceSpanCollector;", "defaultCollector", "exporters", "", "Lcom/liveperson/infra/otel/exporters/OtlpExporter;", "isEnable", "", "mOtlpResource", "Lcom/liveperson/infra/otel/models/OtlpResource;", "parentCollector", "begin", "Lcom/liveperson/infra/otel/LPTraceSpan;", "dataType", "Lcom/liveperson/infra/otel/LPTraceType;", "attributes", "Lcom/liveperson/infra/otel/models/OtlpAttribute;", "disable", "", "enable", "endParentCollector", "otelFullUrl", "export", "getSpanByTraceType", "traceType", "init", "accountId", "initResource", "prepareParentCollector", "setExporter", "infra_release"})
public final class LPTelemetryManager {
    @NotNull
    public static final LPTelemetryManager INSTANCE = new LPTelemetryManager();
    @NotNull
    private static final String TAG = "LPTelemetryManager";
    @NotNull
    private static final String OTLP_COLLECTOR_ENDPOINT_FORMAT = "https://%s/v1/traces";
    private static final int AUTO_EXPORT_THRESHOLD = 5;
    @NotNull
    private static final String DEFAULT_OTEL_DOMAIN = "empty.liveperson.net";
    private static final int RANDOM_SAMPLING_RATE = Random.Default.nextInt(1, 100);
    @Nullable
    private static LPTraceSpanCollector defaultCollector;
    @Nullable
    private static LPTraceSpanCollector parentCollector;
    @Nullable
    private static LPTraceSpanCollector activeCollector;
    @NotNull
    private static List<? extends OtlpExporter> exporters;
    private static OtlpResource mOtlpResource;
    private static boolean isEnable;

    private LPTelemetryManager() {
    }

    @JvmStatic
    public static final void init(@NotNull String accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        mOtlpResource = INSTANCE.initResource(accountId);
        defaultCollector = new LPTraceSpanCollector(null, 5, 1, null);
    }

    private final OtlpResource initResource(String accountId) {
        Object[] objectArray = new OtlpAttribute[8];
        objectArray[0] = new OtlpAttribute(LPTelemetryAttributeKey.SERVICE_NAME.getValue(), new OtlpValueData.StringValue("android.com.liveperson.lpmessagingsdk"));
        objectArray[1] = new OtlpAttribute(LPTelemetryAttributeKey.TELEMETRY_SDK_LANGUAGE.getValue(), new OtlpValueData.StringValue("Kotlin"));
        objectArray[2] = new OtlpAttribute(LPTelemetryAttributeKey.TELEMETRY_SDK_NAME.getValue(), new OtlpValueData.StringValue("android.mobile.traces"));
        objectArray[3] = new OtlpAttribute(LPTelemetryAttributeKey.OS_TYPE.getValue(), new OtlpValueData.StringValue("Android"));
        String string = LPTelemetryAttributeKey.OS_VERSION.getValue();
        String string2 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RELEASE");
        objectArray[4] = new OtlpAttribute(string, new OtlpValueData.StringValue(string2));
        objectArray[5] = new OtlpAttribute(LPTelemetryAttributeKey.TELEMETRY_SDK_VERSION.getValue(), new OtlpValueData.StringValue("5.23.0-beta01"));
        objectArray[6] = new OtlpAttribute(LPTelemetryAttributeKey.DEVICE_MODEL_IDENTIFIER.getValue(), new OtlpValueData.StringValue(Build.MANUFACTURER + ',' + Build.MODEL));
        objectArray[7] = new OtlpAttribute(LPTelemetryAttributeKey.LP_ACCOUNT_ID.getValue(), new OtlpValueData.StringValue(accountId));
        return new OtlpResource(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final LPTraceSpan prepareParentCollector(@NotNull LPTraceType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        LPTraceSpanCollector collector = new LPTraceSpanCollector(exporters, 0, 2, null);
        LPTraceSpan span = LPTraceSpanCollector.begin$default(collector, dataType, null, 2, null);
        collector.setActiveSpan(span);
        parentCollector = collector;
        return span;
    }

    public static /* synthetic */ LPTraceSpan prepareParentCollector$default(LPTelemetryManager lPTelemetryManager, LPTraceType lPTraceType, int n, Object object) {
        if ((n & 1) != 0) {
            lPTraceType = LPTraceType.SHOW_CONV;
        }
        return lPTelemetryManager.prepareParentCollector(lPTraceType);
    }

    public final void endParentCollector(@NotNull String otelFullUrl) {
        Intrinsics.checkNotNullParameter((Object)otelFullUrl, (String)"otelFullUrl");
        this.setExporter(otelFullUrl);
        LPTraceSpanCollector lPTraceSpanCollector = parentCollector;
        if (lPTraceSpanCollector != null) {
            lPTraceSpanCollector.endActiveSpan();
        }
        LPTraceSpanCollector lPTraceSpanCollector2 = parentCollector;
        if (lPTraceSpanCollector2 != null) {
            lPTraceSpanCollector2.export();
        }
        parentCollector = null;
    }

    @JvmOverloads
    @Nullable
    public final LPTraceSpan begin(@NotNull LPTraceType dataType, @NotNull List<OtlpAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        if (LPTraceType.NOT_TRACKING == dataType) {
            return null;
        }
        LPTraceSpanCollector lPTraceSpanCollector = parentCollector;
        if (lPTraceSpanCollector == null) {
            lPTraceSpanCollector = defaultCollector;
        }
        LPTraceSpanCollector lPTraceSpanCollector2 = activeCollector = lPTraceSpanCollector;
        return lPTraceSpanCollector2 != null ? lPTraceSpanCollector2.begin(dataType, attributes) : null;
    }

    public static /* synthetic */ LPTraceSpan begin$default(LPTelemetryManager lPTelemetryManager, LPTraceType lPTraceType, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return lPTelemetryManager.begin(lPTraceType, list);
    }

    @Nullable
    public final LPTraceSpan getSpanByTraceType(@NotNull LPTraceType traceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)traceType), (String)"traceType");
        LPTraceSpanCollector lPTraceSpanCollector = activeCollector;
        return lPTraceSpanCollector != null ? lPTraceSpanCollector.getSpanByTraceType(traceType) : null;
    }

    private final void enable() {
        isEnable = true;
    }

    private final void disable() {
        isEnable = false;
        defaultCollector = null;
        parentCollector = null;
    }

    private final void setExporter(String otelFullUrl) {
        block6: {
            String domain = OtelUtils.INSTANCE.extractDomain(otelFullUrl);
            int samplingRate = OtelUtils.INSTANCE.extractSamplingFromDomain(otelFullUrl);
            if (RANDOM_SAMPLING_RATE > samplingRate) {
                this.disable();
            } else {
                this.enable();
            }
            if (!isEnable || ((CharSequence)domain).length() == 0 || StringsKt.equals((String)domain, (String)DEFAULT_OTEL_DOMAIN, (boolean)true)) {
                return;
            }
            if (mOtlpResource == null) {
                return;
            }
            String string = OTLP_COLLECTOR_ENDPOINT_FORMAT;
            Object[] objectArray = new Object[]{domain};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            OtlpResource otlpResource = mOtlpResource;
            if (otlpResource == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mOtlpResource");
                otlpResource = null;
            }
            OtlpHttpExporter exporter = new OtlpHttpExporter(string2, otlpResource);
            LPTraceSpanCollector lPTraceSpanCollector = defaultCollector;
            if (lPTraceSpanCollector != null) {
                lPTraceSpanCollector.setExporters(CollectionsKt.listOf((Object)exporter));
            }
            LPTraceSpanCollector lPTraceSpanCollector2 = parentCollector;
            if (lPTraceSpanCollector2 == null) break block6;
            lPTraceSpanCollector2.setExporters(CollectionsKt.listOf((Object)exporter));
        }
    }

    public final void export(@NotNull String otelFullUrl) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)otelFullUrl, (String)"otelFullUrl");
            this.setExporter(otelFullUrl);
            if (!isEnable) {
                return;
            }
            LPTraceSpanCollector lPTraceSpanCollector = defaultCollector;
            if (lPTraceSpanCollector != null) {
                lPTraceSpanCollector.export();
            }
            LPTraceSpanCollector lPTraceSpanCollector2 = parentCollector;
            if (lPTraceSpanCollector2 != null) {
                lPTraceSpanCollector2.endActiveSpan();
            }
            LPTraceSpanCollector lPTraceSpanCollector3 = parentCollector;
            if (lPTraceSpanCollector3 != null) {
                lPTraceSpanCollector3.export();
            }
            LPTraceSpanCollector lPTraceSpanCollector4 = defaultCollector;
            if (lPTraceSpanCollector4 != null) {
                lPTraceSpanCollector4.flush();
            }
            LPTraceSpanCollector lPTraceSpanCollector5 = parentCollector;
            if (lPTraceSpanCollector5 == null) break block5;
            lPTraceSpanCollector5.flush();
        }
    }

    @JvmOverloads
    @Nullable
    public final LPTraceSpan begin(@NotNull LPTraceType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return LPTelemetryManager.begin$default(this, dataType, null, 2, null);
    }

    static {
        LPTraceSpanCollector lPTraceSpanCollector = parentCollector;
        if (lPTraceSpanCollector == null) {
            lPTraceSpanCollector = defaultCollector;
        }
        activeCollector = lPTraceSpanCollector;
        exporters = CollectionsKt.emptyList();
        isEnable = true;
    }
}

