/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.analytics;

import com.liveperson.infra.analytics.EventName;
import com.liveperson.infra.analytics.EventProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u0006\u0010\t\u001a\u00020\bJ\u0013\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/analytics/AnalyticsEvent;", "", "eventName", "eventProperty", "", "Lcom/liveperson/infra/analytics/EventProperty;", "(Ljava/lang/Object;[Lcom/liveperson/infra/analytics/EventProperty;)V", "eventError", "", "getEventName", "()Ljava/lang/Object;", "eventProperties", "[Lcom/liveperson/infra/analytics/EventProperty;", "getError", "getEventProperties", "()[Lcom/liveperson/infra/analytics/EventProperty;", "infra_release"})
public final class AnalyticsEvent {
    @NotNull
    private final Object eventName;
    @NotNull
    private final EventProperty[] eventProperties;
    @Nullable
    private String eventError;

    public AnalyticsEvent(@NotNull Object eventName, EventProperty ... eventProperty) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)eventProperty, (String)"eventProperty");
        this.eventName = eventName;
        this.eventProperties = eventProperty;
        this.eventError = "";
    }

    @NotNull
    public final Object getEventName() {
        return this.eventName;
    }

    @NotNull
    public final EventProperty[] getEventProperties() {
        return this.eventProperties;
    }

    @NotNull
    public final String getEventName() {
        if (this.eventName instanceof EventName.LivePerson) {
            return ((EventName.LivePerson)((Object)this.eventName)).getApiName();
        }
        if (this.eventName instanceof EventName.ConsumerAction) {
            return ((EventName.ConsumerAction)((Object)this.eventName)).getApiName();
        }
        return "";
    }

    @Nullable
    public final String getError() {
        for (EventProperty property : this.eventProperties) {
            if (!Intrinsics.areEqual((Object)property.getPropertyName(), (Object)"error") || !(property.getPropertyValue() instanceof String) || !(((CharSequence)property.getPropertyValue()).length() > 0)) continue;
            this.eventError = (String)property.getPropertyValue();
        }
        return this.eventError;
    }
}

