/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.analytics;

import android.content.Context;
import android.os.Build;
import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.analytics.EventProperty;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.AnalyticsUtils;
import com.liveperson.infra.utils.DeviceUtils;
import com.liveperson.infra.utils.VersionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0019\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\tJ\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/liveperson/infra/analytics/AnalyticsService;", "", "()V", "appContext", "Landroid/content/Context;", "appId", "", "brandId", "isAnalyticsEnabled", "", "sessionId", "userEvents", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/liveperson/infra/analytics/AnalyticsEvent;", "userProperties", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getBrandAppId", "getSessionId", "init", "", "applicationContext", "logUserEvent", "analyticsEvent", "setAppContext", "setBrandId", "setIsAnalyticsEnabled", "isEnabled", "setUserProperties", "Companion", "infra_release"})
public class AnalyticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Context appContext;
    private String brandId;
    @NotNull
    private String appId = "";
    @NotNull
    private HashMap<String, Object> userProperties = new HashMap();
    @NotNull
    private LinkedBlockingQueue<AnalyticsEvent> userEvents = new LinkedBlockingQueue();
    private boolean isAnalyticsEnabled = true;
    @NotNull
    private String sessionId = "";
    @NotNull
    private static final String TAG = "AnalyticsService";
    @NotNull
    private static final String BRAND_ID = "accountID";
    @NotNull
    private static final String APP_ID = "hostAppName";
    @NotNull
    private static final String APP_VERSION = "hostAppVersion";
    @NotNull
    private static final String SDK_VERSION = "sdkVersion";
    @NotNull
    private static final String DEVICE_API = "deviceApi";
    @NotNull
    private static final String DEVICE_LANGUAGE = "language";
    @NotNull
    private static final String DEVICE_SCRIPT = "deviceScript";
    @NotNull
    private static final String DEVICE_REGION = "region";
    @NotNull
    private static final String DEVICE_TIME_ZONE = "geoip.timezone";
    @NotNull
    private static final String DEVICE_MAKE = "deviceFamily";
    @NotNull
    private static final String DEVICE_MODEL = "deviceModel";
    @NotNull
    private static final String DEVICE_OS = "deviceOS";
    @NotNull
    private static final String DEVICE_OS_VERSION = "deviceOSVersion";
    @NotNull
    private static final String LOG_TIME = "event_time";
    @NotNull
    private static final String SESSION_ID = "sessionId";

    public final void init(@NotNull Context applicationContext, @NotNull String brandId, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.appContext = applicationContext;
        this.brandId = brandId;
        this.appId = appId;
        this.setUserProperties();
    }

    public void logUserEvent(@Nullable AnalyticsEvent analyticsEvent) {
        try {
            if (!this.isAnalyticsEnabled || analyticsEvent == null) {
                LPLog.INSTANCE.d(TAG, "logUserEvent: Analytics is disabled. Do not log event.");
                return;
            }
            if (this.brandId == null) {
                LPLog.INSTANCE.d(TAG, "logUserEvent: We don't have brandId yet. Use empty");
                this.brandId = "";
            }
            Object[] objectArray = new EventProperty[2];
            objectArray[0] = new EventProperty(LOG_TIME, AnalyticsUtils.INSTANCE.getStartTime());
            String string = this.brandId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brandId");
                string = null;
            }
            objectArray[1] = new EventProperty(BRAND_ID, string);
            EventProperty[] eventProperties = (EventProperty[])ArraysKt.plus((Object[])objectArray, (Object[])analyticsEvent.getEventProperties());
            LPLog.INSTANCE.d(TAG, "logUserEvent: Adding user event " + analyticsEvent.getEventName() + " into the list.");
            this.userEvents.add(new AnalyticsEvent(analyticsEvent.getEventName(), Arrays.copyOf(eventProperties, eventProperties.length)));
            LPLog.INSTANCE.d(TAG, "logUserEvent: Total events cached: " + this.userEvents.size());
        }
        catch (Exception exception) {
            LPLog.INSTANCE.w(TAG, "logUserEvent: Failed to log user event: ", exception);
        }
    }

    private final void setUserProperties() {
        try {
            this.userProperties.put(APP_ID, this.getBrandAppId());
            Context context = this.appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
                context = null;
            }
            this.userProperties.put(APP_VERSION, VersionUtils.getAppVersion(context));
            this.userProperties.put(SDK_VERSION, "5.23.1");
            String string = this.brandId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brandId");
                string = null;
            }
            this.userProperties.put(BRAND_ID, string);
            this.userProperties.put(DEVICE_API, Build.VERSION.SDK_INT);
            this.userProperties.put(DEVICE_LANGUAGE, Locale.getDefault().toString());
            this.userProperties.put(DEVICE_REGION, Locale.getDefault().getCountry());
            this.userProperties.put(DEVICE_TIME_ZONE, TimeZone.getDefault().getID());
            this.userProperties.put(DEVICE_MAKE, Build.MANUFACTURER);
            this.userProperties.put(DEVICE_MODEL, Build.MODEL);
            this.userProperties.put(DEVICE_OS, DeviceUtils.INSTANCE.getOsName());
            this.userProperties.put(DEVICE_OS_VERSION, Build.VERSION.RELEASE);
            this.userProperties.put(SESSION_ID, this.getSessionId());
        }
        catch (Exception e) {
            LPLog.INSTANCE.w(TAG, "setUserProperties: Exception while mapping user properties.", e);
        }
    }

    public final void setBrandId(@Nullable String brandId) {
        if (brandId != null && ((CharSequence)brandId).length() > 0) {
            this.brandId = brandId;
        }
    }

    public final void setAppContext(@Nullable Context appContext) {
        if (appContext != null) {
            this.appContext = appContext;
        }
    }

    public final void setIsAnalyticsEnabled(boolean isEnabled) {
        this.isAnalyticsEnabled = isEnabled;
    }

    private final String getBrandAppId() {
        if (((CharSequence)this.appId).length() == 0) {
            String string = this.brandId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"brandId");
                string = null;
            }
            if (((CharSequence)string).length() > 0) {
                LPLog.INSTANCE.d(TAG, "getBrandAppId: Missing appId, trying to get it from shared preference.");
                PreferenceManager preferenceManager = PreferenceManager.getInstance();
                String string2 = this.brandId;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"brandId");
                    string2 = null;
                }
                String string3 = preferenceManager.getStringValue("APP_ID_PREFERENCE_KEY", string2, "");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInstance().getStringV\u2026FERENCE_KEY, brandId, \"\")");
                this.appId = string3;
            }
        }
        return this.appId;
    }

    private final String getSessionId() {
        if (((CharSequence)this.sessionId).length() == 0) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            this.sessionId = string;
        }
        return this.sessionId;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/analytics/AnalyticsService$Companion;", "", "()V", "APP_ID", "", "APP_VERSION", "BRAND_ID", "DEVICE_API", "DEVICE_LANGUAGE", "DEVICE_MAKE", "DEVICE_MODEL", "DEVICE_OS", "DEVICE_OS_VERSION", "DEVICE_REGION", "DEVICE_SCRIPT", "DEVICE_TIME_ZONE", "LOG_TIME", "SDK_VERSION", "SESSION_ID", "TAG", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

