/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.markdown;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\"\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/infra/utils/markdown/MarkdownHyperlinkItem;", "", "()V", "end", "", "getEnd", "()I", "setEnd", "(I)V", "<set-?>", "", "link", "getLink", "()Ljava/lang/String;", "start", "getStart", "setStart", "title", "getTitle", "buildHyperlinkItem", "", "message", "findMiddleBracketsIndexes", "", "string", "isValid", "", "Companion", "infra_release"})
public final class MarkdownHyperlinkItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int start = -1;
    private int end = -1;
    @Nullable
    private String title;
    @Nullable
    private String link;
    @NotNull
    private static final String EMPTY_STRING = "";
    private static final int BRACKET_CHARACTER_LENGTH = 1;
    @NotNull
    private static final String MIDDLE_BRACKETS = "](";
    @NotNull
    private static final String HTTP_STRING = "http://";
    @NotNull
    private static final String HTTPS_STRING = "https://";

    public final int getStart() {
        return this.start;
    }

    public final void setStart(int n) {
        this.start = n;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void setEnd(int n) {
        this.end = n;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getLink() {
        return this.link;
    }

    public final void buildHyperlinkItem(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message.substring(this.start, this.end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = string;
        int titleStartIndex = "#md#".length() + 1;
        List<Integer> middleBracketsIndexList = this.findMiddleBracketsIndexes(string2);
        int lastUrlCharacterIndex = string2.length() - "#/md#".length() - 1;
        Iterator<Integer> iterator = middleBracketsIndexList.iterator();
        while (iterator.hasNext()) {
            int middleBracketsIndex = ((Number)iterator.next()).intValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(titleStartIndex, middleBracketsIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.title = this.title;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(middleBracketsIndex + MIDDLE_BRACKETS.length(), lastUrlCharacterIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.link = this.link;
            if (this.link == null) {
                this.link = EMPTY_STRING;
                break;
            }
            String string3 = this.link;
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.startsWith((String)string3, (String)HTTP_STRING, (boolean)true)) break;
            String string4 = this.link;
            Intrinsics.checkNotNull((Object)string4);
            if (!StringsKt.startsWith((String)string4, (String)HTTPS_STRING, (boolean)true)) continue;
            break;
        }
    }

    public final boolean isValid() {
        return this.start != -1 && this.end > this.start && !TextUtils.isEmpty((CharSequence)this.title) && !TextUtils.isEmpty((CharSequence)this.link);
    }

    private final List<Integer> findMiddleBracketsIndexes(String string) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int index = "#md#".length() + 1;
        while (index <= string.length() - "#/md#".length() - MIDDLE_BRACKETS.length()) {
            String string2 = string.substring(index, index + MIDDLE_BRACKETS.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)MIDDLE_BRACKETS, (Object)string2)) {
                indexList.add(index);
                index += MIDDLE_BRACKETS.length();
                continue;
            }
            ++index;
        }
        return indexList;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/utils/markdown/MarkdownHyperlinkItem$Companion;", "", "()V", "BRACKET_CHARACTER_LENGTH", "", "EMPTY_STRING", "", "HTTPS_STRING", "HTTP_STRING", "MIDDLE_BRACKETS", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

