package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class BrandProfileTable implements BaseTable {

    private static final String TAG = "BrandProfileTable";

    //Brand profile table name
    private static final String BRAND_TABLE = "brandProfile";

    //Brand profile table columns
    private static final String KEY_BIO = "bio";
    private static final String KEY_BRAND_ID = "brandId";
    private static final String KEY_SKILL = "skill";
    private static final String KEY_COVER_IMAGE = "coverImage";
    private static final String KEY_NAME = "name";
    private static final String KEY_LOGO_IMAGE = "logoImage";
    private static final String KEY_IS_SAVED = "isSaved";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getTableName() {
        return BRAND_TABLE;
    }

    @Override
    public String getCreateCommand() {
        return "create table " + BRAND_TABLE + "(" +
                KEY_ID + " integer primary key autoincrement," +
                KEY_BIO + " text," +
                KEY_NAME + " text not null," +
                KEY_BRAND_ID + " text not null," +
                KEY_SKILL + " text," +
                KEY_LOGO_IMAGE + " text," +
                KEY_IS_SAVED + " integer," +
                KEY_COVER_IMAGE + " text" +
                ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
    }
}
