package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class UsersTable implements BaseTable {

    private static final String TAG = "UsersTable";

    //Users table name
    public static final String USERS_TABLE = "users";

    //Users table columns
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_FIRST_NAME = "firstName";
    public static final String KEY_LAST_NAME = "lastName";
    public static final String KEY_NICKNAME = "nickname";
    public static final String KEY_PHONE_NUMBER = "phoneNumber";
    public static final String KEY_USER_TYPE = "userType";
    public static final String KEY_ORIGINATOR_ID = "originatorId";
    public static final String KEY_BRAND_ID = "brandId";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_PROFILE_IMAGE = "profileImage";
    public static final String KEY_COVER_IMAGE = "coverImage";
    public static final String KEY_REQUEST_ID = "requestId";
    public static final String KEY_ENCRYPTION_VERSION = "encryptVer";

    public static final String ENCRYPTION_VERSION_CURSOR_AS_VALUE = "user_encryptVer";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getTableName() {
        return USERS_TABLE;
    }

    @Override
    public String getCreateCommand() {
        return "create table " + USERS_TABLE + "(" +
                KEY_ID + " integer primary key autoincrement," +
                KEY_ORIGINATOR_ID + " text unique not null," +
                KEY_BRAND_ID + " text," +
                KEY_DESCRIPTION + " text," +
                KEY_FIRST_NAME + " text not null," +
                KEY_LAST_NAME + " text," +
                KEY_NICKNAME + " text," +
                KEY_PHONE_NUMBER + " text," +
                KEY_USER_TYPE + " integer not null," +
                KEY_REQUEST_ID + " big int," +
                KEY_EMAIL + " text," +
                KEY_PROFILE_IMAGE + " text," +
                KEY_ENCRYPTION_VERSION + " integer not null," +
                KEY_COVER_IMAGE + " text" +
                ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
    }
}
