/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.content.ContentValues;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.controller.DBEncryptionService;
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand;
import com.liveperson.infra.database.transaction_helper.InsertSQLCommand;
import com.liveperson.infra.database.transaction_helper.SQLiteCommand;
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand;
import com.liveperson.infra.utils.EncryptionVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"encrypt", "Landroid/content/ContentValues;", "messageValues", "encryptTransactionData", "", "command", "Lcom/liveperson/infra/database/transaction_helper/SQLiteCommand;", "infra_release"})
@SourceDebugExtension(value={"SMAP\nDBEncryptionServiceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DBEncryptionServiceUtils.kt\ncom/liveperson/infra/controller/DBEncryptionServiceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class DBEncryptionServiceUtilsKt {
    @Nullable
    public static final ContentValues encrypt(@NotNull ContentValues messageValues) {
        String metadata;
        Intrinsics.checkNotNullParameter((Object)messageValues, (String)"messageValues");
        EncryptionVersion messageEncryptionVersion = DBEncryptionService.Companion.getAppEncryptionVersion();
        messageValues.put("encryptVer", Integer.valueOf(messageEncryptionVersion.ordinal()));
        String message = messageValues.getAsString("text");
        if (message != null) {
            String encryptedMessage = DBEncryptionHelper.encrypt(messageEncryptionVersion, message);
            messageValues.put("text", encryptedMessage);
        }
        if ((metadata = messageValues.getAsString("metadata")) != null) {
            String encryptedMetadata = DBEncryptionHelper.encrypt(messageEncryptionVersion, metadata);
            messageValues.put("metadata", encryptedMetadata);
        }
        return messageValues;
    }

    public static final void encryptTransactionData(@NotNull SQLiteCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        switch (command.getType()) {
            case 0: {
                InsertSQLCommand insertSQLCommand = command instanceof InsertSQLCommand ? (InsertSQLCommand)command : null;
                if (insertSQLCommand != null && (insertSQLCommand = insertSQLCommand.getContentValues()) != null) {
                    InsertSQLCommand it = insertSQLCommand;
                    boolean bl = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
            case 1: {
                UpdateSQLCommand updateSQLCommand = command instanceof UpdateSQLCommand ? (UpdateSQLCommand)command : null;
                if (updateSQLCommand != null && (updateSQLCommand = updateSQLCommand.getContentValues()) != null) {
                    UpdateSQLCommand it = updateSQLCommand;
                    boolean bl = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
            case 2: {
                InsertOrUpdateSQLCommand insertOrUpdateSQLCommand;
                InsertOrUpdateSQLCommand it;
                InsertOrUpdateSQLCommand currentCommand = command instanceof InsertOrUpdateSQLCommand ? (InsertOrUpdateSQLCommand)command : null;
                InsertOrUpdateSQLCommand insertOrUpdateSQLCommand2 = currentCommand;
                if (insertOrUpdateSQLCommand2 != null && (insertOrUpdateSQLCommand2 = insertOrUpdateSQLCommand2.getContentValuesForInsert()) != null) {
                    it = insertOrUpdateSQLCommand2;
                    boolean bl = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                if ((insertOrUpdateSQLCommand = currentCommand) != null && (insertOrUpdateSQLCommand = insertOrUpdateSQLCommand.getContentValuesForUpdate()) != null) {
                    it = insertOrUpdateSQLCommand;
                    boolean bl = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
        }
    }
}

