/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.LPJSONArrayBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BU\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/liveperson/infra/network/http/requests/EventManagerRequest;", "Lcom/liveperson/infra/Command;", "domain", "", "accountId", "token", "messages", "", "Lorg/json/JSONObject;", "certificates", "callback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/liveperson/infra/ICallback;)V", "getAccountId", "()Ljava/lang/String;", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getCertificates", "()Ljava/util/List;", "getDomain", "getMessages", "getToken", "execute", "", "Companion", "infra_release"})
public final class EventManagerRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String domain;
    @NotNull
    private final String accountId;
    @NotNull
    private final String token;
    @Nullable
    private final List<JSONObject> messages;
    @Nullable
    private final List<String> certificates;
    @Nullable
    private final ICallback<String, Exception> callback;
    @NotNull
    private static final String TAG = "EventManagerRequest";
    @NotNull
    private static final String EVENT_MANAGER_URL = "https://%s/api/account/%s/events";

    public EventManagerRequest(@Nullable String domain, @NotNull String accountId, @NotNull String token, @Nullable List<? extends JSONObject> messages, @Nullable List<String> certificates, @Nullable ICallback<String, Exception> callback2) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.domain = domain;
        this.accountId = accountId;
        this.token = token;
        this.messages = messages;
        this.certificates = certificates;
        this.callback = callback2;
    }

    @Nullable
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final List<JSONObject> getMessages() {
        return this.messages;
    }

    @Nullable
    public final List<String> getCertificates() {
        return this.certificates;
    }

    @Nullable
    public final ICallback<String, Exception> getCallback() {
        return this.callback;
    }

    @Override
    public void execute() {
        Collection collection = this.messages;
        if (collection == null || collection.isEmpty()) {
            LPLog.INSTANCE.w(TAG, "Domain or Message is empty. Did not send log to event manager.");
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (JSONObject message : this.messages) {
            LPLog.INSTANCE.d(TAG, "sending event: " + message);
            jsonArray.put((Object)message);
        }
        String string = EVENT_MANAGER_URL;
        Object[] objectArray = new Object[]{this.domain, this.accountId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String requestUrl = string2;
        HttpPostRequest postRequest = new HttpPostRequest(requestUrl, LPTraceType.HTTP_REQUEST);
        postRequest.addHeader("Authorization", "Bearer " + this.token);
        postRequest.setBody(new LPJSONArrayBody(jsonArray));
        postRequest.setCertificatePinningKeys(this.certificates);
        postRequest.setCallback(new ICallback<String, Exception>(this){
            final /* synthetic */ EventManagerRequest this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable String response) {
                block0: {
                    LPLog.INSTANCE.i("EventManagerRequest", "Successfully uploaded report to event manager.");
                    ICallback<String, Exception> iCallback = this.this$0.getCallback();
                    if (iCallback == null) break block0;
                    iCallback.onSuccess(response);
                }
            }

            public void onError(@Nullable Exception exception) {
                block0: {
                    LPLog.INSTANCE.i("EventManagerRequest", "Error uploading report to event manager.", exception);
                    ICallback<String, Exception> iCallback = this.this$0.getCallback();
                    if (iCallback == null) break block0;
                    iCallback.onError((Exception)((Throwable)exception));
                }
            }
        });
        HttpHandler.execute(postRequest);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/infra/network/http/requests/EventManagerRequest$Companion;", "", "()V", "EVENT_MANAGER_URL", "", "TAG", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

