/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import com.liveperson.infra.IDisposable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import java.util.ArrayList;
import java.util.List;

public class SocketStateManager
implements IDisposable {
    private static final String TAG = "SocketStateManager";
    private List<SocketStateListener> mCallbacks = new ArrayList<SocketStateListener>();
    private SocketState mState = SocketState.INIT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(SocketState state) {
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            if (this.mState == state) {
                LPLog.INSTANCE.d(TAG, "Request state and current state are equal");
                return;
            }
            LPLog.INSTANCE.d(TAG, "new socket state " + state.name());
            this.mState = state;
            ArrayList<SocketStateListener> mCopyCallbacks = new ArrayList<SocketStateListener>(this.mCallbacks);
            for (SocketStateListener callback2 : mCopyCallbacks) {
                LPLog.INSTANCE.d(TAG, "Calling listener " + callback2.toString() + " new socket state " + state.name());
                callback2.onStateChanged(this.mState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected(String reason, int code) {
        LPLog.INSTANCE.d(TAG, "onDisconnected, reason " + reason + " code " + code);
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            ArrayList<SocketStateListener> mCopyCallbacks = new ArrayList<SocketStateListener>(this.mCallbacks);
            for (SocketStateListener callback2 : mCopyCallbacks) {
                callback2.onDisconnected(reason, code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SocketStateListener callback2) {
        LPLog.INSTANCE.i(TAG, "register SocketStateListener " + callback2.hashCode());
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            if (!this.mCallbacks.contains(callback2)) {
                this.mCallbacks.add(callback2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SocketStateListener callback2) {
        LPLog.INSTANCE.i(TAG, "unregister SocketStateListener " + callback2.hashCode());
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            this.mCallbacks.remove(callback2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketState getState() {
        LPLog.INSTANCE.d(TAG, "getState");
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        LPLog.INSTANCE.i(TAG, "dispose");
        SocketStateManager socketStateManager = this;
        synchronized (socketStateManager) {
            this.mCallbacks.clear();
        }
    }
}

