/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.LocaleUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private static Calendar mCalendar = Calendar.getInstance();
    private static final String TAG = DateUtils.class.getSimpleName();

    public static boolean isYesterday(long when) {
        mCalendar.setTimeInMillis(when);
        int msgYear = mCalendar.get(1);
        int msgMonth = mCalendar.get(2);
        int msgMonthDay = mCalendar.get(5);
        mCalendar.clear();
        mCalendar.setTimeInMillis(System.currentTimeMillis());
        mCalendar.add(5, -1);
        int yesterdayYear = mCalendar.get(1);
        int yesterdayMonth = mCalendar.get(2);
        int yesterdayMonthDay = mCalendar.get(5);
        mCalendar.clear();
        return msgYear == yesterdayYear && msgMonth == yesterdayMonth && msgMonthDay == yesterdayMonthDay;
    }

    public static boolean isInTheLast24hours(long when) {
        return System.currentTimeMillis() - 86400000L < when;
    }

    public static boolean isTomorrow(long when) {
        mCalendar.setTimeInMillis(when);
        int msgYear = mCalendar.get(1);
        int msgMonth = mCalendar.get(2);
        int msgMonthDay = mCalendar.get(5);
        mCalendar.clear();
        mCalendar.setTimeInMillis(System.currentTimeMillis());
        mCalendar.add(5, 1);
        int tomorrowYear = mCalendar.get(1);
        int tomorrowMonth = mCalendar.get(2);
        int tomorrowMonthDay = mCalendar.get(5);
        mCalendar.clear();
        return msgYear == tomorrowYear && msgMonth == tomorrowMonth && msgMonthDay == tomorrowMonthDay;
    }

    public static long getBeginningOfDayTime(long timeStamp) {
        long defaultMaxValue = Long.MAX_VALUE;
        if (timeStamp < 0L) {
            LPLog.INSTANCE.d(TAG, "TimeStamp is negative value = " + timeStamp);
            timeStamp = defaultMaxValue;
        }
        long actualTimeStamp = timeStamp;
        if (timeStamp >= 0x7FFFFFFFFFFFFFFDL) {
            actualTimeStamp = System.currentTimeMillis();
        }
        Locale locale = LocaleUtils.getInstance().getLocale();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTimeInMillis(actualTimeStamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static boolean isToday(long timeStamp) {
        Calendar now = Calendar.getInstance();
        Calendar cdate = Calendar.getInstance();
        cdate.setTimeInMillis(timeStamp);
        return now.get(1) == cdate.get(1) && now.get(2) == cdate.get(2) && now.get(5) == cdate.get(5);
    }

    public static String getFormattedTime(@Nullable String customTimeFormat, int defaultTimeFormatLength, long timeToFormat) {
        DateFormat format = DateUtils.getTimeFormat(customTimeFormat, defaultTimeFormatLength);
        return format.format(new Date(timeToFormat));
    }

    public static String getFormattedTime(@Nullable String customTimeFormat, int defaultTimeFormatLength, long timeToFormat, @Nullable String customTimeZone) {
        DateFormat format = DateUtils.getTimeFormat(customTimeFormat, defaultTimeFormatLength);
        if (!TextUtils.isEmpty((CharSequence)customTimeZone)) {
            format.setTimeZone(TimeZone.getTimeZone(customTimeZone));
        }
        return format.format(new Date(timeToFormat));
    }

    private static DateFormat getTimeFormat(String customTimeFormat, int timeFormatLength) {
        Locale locale = LocaleUtils.getInstance().getLocale();
        DateFormat format = !TextUtils.isEmpty((CharSequence)customTimeFormat) ? new SimpleDateFormat(customTimeFormat, locale) : DateFormat.getTimeInstance(timeFormatLength, locale);
        return format;
    }

    public static String getFormattedDate(String customDateFormat, int dateFormatLength, long dateToFormat) {
        Locale locale = LocaleUtils.getInstance().getLocale();
        DateFormat format = !TextUtils.isEmpty((CharSequence)customDateFormat) ? new SimpleDateFormat(customDateFormat, locale) : DateFormat.getDateInstance(dateFormatLength, locale);
        return format.format(new Date(dateToFormat));
    }

    public static DateFormat getDateFormat(String customDateTimeFormat, int dateFormatLength, int timeFormatLength) {
        Locale locale = LocaleUtils.getInstance().getLocale();
        DateFormat format = !TextUtils.isEmpty((CharSequence)customDateTimeFormat) ? new SimpleDateFormat(customDateTimeFormat, locale) : DateFormat.getDateTimeInstance(dateFormatLength, timeFormatLength, locale);
        return format;
    }

    public static String getDurationString(long durationInMilliseconds) {
        if (durationInMilliseconds < 0L) {
            throw new IllegalArgumentException("Negative durationInMilliseconds " + durationInMilliseconds);
        }
        Date date = new Date(durationInMilliseconds);
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss", Locale.getDefault());
        return formatter.format(date);
    }
}

