/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.util.Base64;
import com.liveperson.infra.model.PKCEParams;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/infra/utils/PKCEUtils;", "", "()V", "JWE_ALGORITHM", "Lcom/nimbusds/jose/JWEAlgorithm;", "kotlin.jvm.PlatformType", "JWE_ENCRYPTION_METHOD", "Lcom/nimbusds/jose/EncryptionMethod;", "generateCodeChallenge", "", "codeVerifier", "generateCodeVerifier", "generateEncryptedCodeVerifier", "kId", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "generatePKCEParams", "Lcom/liveperson/infra/model/PKCEParams;", "infra_release"})
public final class PKCEUtils {
    @NotNull
    public static final PKCEUtils INSTANCE = new PKCEUtils();
    private static final JWEAlgorithm JWE_ALGORITHM = JWEAlgorithm.RSA_OAEP_256;
    private static final EncryptionMethod JWE_ENCRYPTION_METHOD = EncryptionMethod.A256GCM;

    private PKCEUtils() {
    }

    private final String generateCodeChallenge(String codeVerifier) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        Charset charset = Charset.forName("US-ASCII");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = codeVerifier.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(\"SHA-256\")");
        MessageDigest messageDigest2 = messageDigest;
        messageDigest2.update(bytes, 0, bytes.length);
        byte[] byArray2 = messageDigest2.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"messageDigest.digest()");
        byte[] digest = byArray2;
        int base64Flags = 11;
        String string = Base64.encodeToString((byte[])digest, (int)base64Flags);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(digest, base64Flags)");
        return string;
    }

    private final String generateCodeVerifier() throws UnsupportedEncodingException {
        int minLength = 43;
        int maxLength = 128;
        SecureRandom secureRandom = new SecureRandom();
        int codeVerifierLength = secureRandom.nextInt(maxLength - minLength + 1) + minLength;
        byte[] codeVerifier = new byte[128];
        secureRandom.nextBytes(codeVerifier);
        int base64Flags = 11;
        String string = Base64.encodeToString((byte[])codeVerifier, (int)base64Flags);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(codeVerifier, base64Flags)");
        String string2 = string;
        int n = 0;
        String string3 = string2.substring(n, codeVerifierLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    private final String generateEncryptedCodeVerifier(String codeVerifier, String kId, JWK jwk) {
        String string;
        String jsonCodeVerifier = "{\"code_verifier\":\"" + codeVerifier + "\"}";
        JWEHeader header = new JWEHeader.Builder(JWE_ALGORITHM, JWE_ENCRYPTION_METHOD).keyID(kId).build();
        Payload payload = new Payload(jsonCodeVerifier);
        JWEObject jweObject = new JWEObject(header, payload);
        if (jwk instanceof RSAKey) {
            RSAEncrypter encrypter = new RSAEncrypter(((RSAKey)jwk).toRSAPublicKey());
            jweObject.encrypt((JWEEncrypter)encrypter);
            String string2 = jweObject.serialize();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val encryp\u2026ect.serialize()\n        }");
            string = string2;
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final PKCEParams generatePKCEParams(@NotNull String kId, @NotNull JWK jwk) {
        Intrinsics.checkNotNullParameter((Object)kId, (String)"kId");
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        String codeVerifier = this.generateCodeVerifier();
        String codeChallenge = this.generateCodeChallenge(codeVerifier);
        String strJWE = this.generateEncryptedCodeVerifier(codeVerifier, kId, jwk);
        return new PKCEParams(strJWE, codeChallenge, null, 4, null);
    }
}

