/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.configuration;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import androidx.annotation.BoolRes;
import androidx.annotation.DimenRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.AndroidFrameworkUtils;
import com.liveperson.infra.utils.MetricsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration {
    private static final String TAG = "Configuration";
    private static final String SHARED_PREFERENCES_FILE_NAME = "lp_runtime_config";
    private static final String RUNTIME_CONFIGURATION_KEYS = "runtimeConfigurationKeys";

    public static boolean getBoolean(@BoolRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        return Configuration.getConfigurationShPrefs().getBoolean(String.valueOf(resId), context.getResources().getBoolean(resId));
    }

    public static float getDimension(@DimenRes int resId) {
        return Configuration.getDimension(resId, 1);
    }

    public static float getDimension(@DimenRes int resId, int unit) {
        float result;
        float xmlValue = 0.0f;
        Context context = Infra.instance.getApplicationContext();
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
            switch (unit) {
                case 2: {
                    xmlValue = MetricsUtils.convertPixelsToSp(context.getResources().getDimension(resId), context);
                    break;
                }
                case 1: {
                    xmlValue = MetricsUtils.convertPixelsToDp(context.getResources().getDimension(resId), context);
                    break;
                }
                case 0: {
                    xmlValue = context.getResources().getDimension(resId);
                    break;
                }
                default: {
                    LPLog.INSTANCE.w(TAG, "not supported unit");
                }
            }
            result = sharedPreferences.getFloat(String.valueOf(resId), xmlValue);
        }
        catch (Resources.NotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000002F, "getDimension: ", e);
            result = -1.0f;
        }
        return result;
    }

    public static int getInteger(@IntegerRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        return Configuration.getConfigurationShPrefs().getInt(String.valueOf(resId), context.getResources().getInteger(resId));
    }

    public static String getString(@StringRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        return Configuration.getConfigurationShPrefs().getString(String.valueOf(resId), context.getResources().getString(resId));
    }

    public static void set(int resId, String stringValue) {
        Configuration.getConfigurationShPrefs().edit().putString(String.valueOf(resId), stringValue).apply();
    }

    public static void set(int resId, boolean booleanValue) {
        Configuration.getConfigurationShPrefs().edit().putBoolean(String.valueOf(resId), booleanValue).apply();
        Configuration.removeIfNull(resId, booleanValue);
    }

    public static void set(int resId, float floatValue) {
        Configuration.getConfigurationShPrefs().edit().putFloat(String.valueOf(resId), floatValue).apply();
        Configuration.removeIfNull(resId, Float.valueOf(floatValue));
    }

    public static void set(int resId, int intValue) {
        Configuration.getConfigurationShPrefs().edit().putInt(String.valueOf(resId), intValue).apply();
        Configuration.removeIfNull(resId, intValue);
    }

    public static void clearAll() {
        Configuration.getConfigurationShPrefs().edit().clear().apply();
    }

    private static void removeIfNull(int resId, @Nullable Object resValue) {
        if (resValue == null) {
            Configuration.getConfigurationShPrefs().edit().remove(String.valueOf(resId)).apply();
        }
    }

    private static SharedPreferences getConfigurationShPrefs() {
        Context context = Infra.instance.getApplicationContext();
        return context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
    }

    public static HashMap<Integer, String> scanXmlIdsAndNames(Class<?> rInnerClass) {
        HashMap<Integer, String> fieldIdMap = new HashMap<Integer, String>();
        if (rInnerClass == null) {
            return fieldIdMap;
        }
        try {
            Field[] fields = rInnerClass.getFields();
            Set<String> keys = Configuration.getConfigurationKeySet();
            for (Field field : fields) {
                if (field == null) continue;
                int id = field.getInt(null);
                if (!keys.contains(field.getName())) continue;
                fieldIdMap.put(id, field.getName());
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000031, "Failed to generate key-value map.", e);
        }
        return fieldIdMap;
    }

    private static Set<String> getConfigurationKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        try {
            JSONObject configurationKeysJsonObject = new JSONObject(Android.loadConfigurationKeysJsonString());
            JSONArray configurationKeysJsonArray = configurationKeysJsonObject.getJSONArray(RUNTIME_CONFIGURATION_KEYS);
            for (int i = 0; i < configurationKeysJsonArray.length(); ++i) {
                keySet.add(configurationKeysJsonArray.getString(i));
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000032, "JSONException while parsing configurationKeys JSON.", e);
        }
        return keySet;
    }

    public static class Android {
        public static String loadConfigurationKeysJsonString() {
            String json = null;
            try {
                InputStream is = AndroidFrameworkUtils.getResources().openRawResource(R.raw.runtime_configuration_keys);
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                is.close();
                json = new String(buffer, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LPLog.INSTANCE.e(Configuration.TAG, ErrorCode.ERR_00000033, "IOException while loading configurationKeys from disk.", e);
            }
            return json;
        }
    }
}

