/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010+H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\b\u0010.\u001a\u00020+H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lcom/liveperson/infra/controller/CipherWrapper;", "", "transformation", "", "opmode", "", "key", "Ljava/security/Key;", "params", "Ljava/security/spec/AlgorithmParameterSpec;", "(Ljava/lang/String;ILjava/security/Key;Ljava/security/spec/AlgorithmParameterSpec;)V", "(Ljava/lang/String;ILjava/security/Key;)V", "cipher", "Ljavax/crypto/Cipher;", "getCipher", "()Ljavax/crypto/Cipher;", "setCipher", "(Ljavax/crypto/Cipher;)V", "getKey", "()Ljava/security/Key;", "setKey", "(Ljava/security/Key;)V", "mParams", "getMParams", "()Ljava/security/spec/AlgorithmParameterSpec;", "setMParams", "(Ljava/security/spec/AlgorithmParameterSpec;)V", "getOpmode", "()I", "setOpmode", "(I)V", "getTransformation", "()Ljava/lang/String;", "setTransformation", "(Ljava/lang/String;)V", "createCipherInputStream", "Ljavax/crypto/CipherInputStream;", "encryptedKey", "createCipherOutputStream", "Ljavax/crypto/CipherOutputStream;", "byteArrayOutputStream", "Ljava/io/ByteArrayOutputStream;", "doFinal", "", "data", "init", "iv", "infra_release"})
public class CipherWrapper {
    @NotNull
    private String transformation;
    private int opmode;
    @Nullable
    private Key key;
    @Nullable
    private AlgorithmParameterSpec mParams;
    public Cipher cipher;

    public CipherWrapper(@NotNull String transformation, int opmode, @Nullable Key key) {
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        this.transformation = transformation;
        this.opmode = opmode;
        this.key = key;
    }

    @NotNull
    public final String getTransformation() {
        return this.transformation;
    }

    public final void setTransformation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.transformation = string;
    }

    public final int getOpmode() {
        return this.opmode;
    }

    public final void setOpmode(int n) {
        this.opmode = n;
    }

    @Nullable
    public final Key getKey() {
        return this.key;
    }

    public final void setKey(@Nullable Key key) {
        this.key = key;
    }

    @Nullable
    public final AlgorithmParameterSpec getMParams() {
        return this.mParams;
    }

    public final void setMParams(@Nullable AlgorithmParameterSpec algorithmParameterSpec) {
        this.mParams = algorithmParameterSpec;
    }

    public CipherWrapper(@NotNull String transformation, int opmode, @Nullable Key key, @Nullable AlgorithmParameterSpec params) {
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        this(transformation, opmode, key);
        this.mParams = params;
    }

    @NotNull
    public final Cipher getCipher() {
        Cipher cipher = this.cipher;
        if (cipher != null) {
            return cipher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cipher");
        return null;
    }

    public final void setCipher(@NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"<set-?>");
        this.cipher = cipher;
    }

    @NotNull
    public CipherWrapper init() {
        if (this.cipher == null) {
            Cipher cipher = Cipher.getInstance(this.transformation);
            Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(transformation)");
            this.setCipher(cipher);
        }
        if (this.mParams != null) {
            this.getCipher().init(this.opmode, this.key, this.mParams);
        } else {
            this.getCipher().init(this.opmode, this.key);
        }
        return this;
    }

    @NotNull
    public byte[] doFinal(@Nullable byte[] data) throws BadPaddingException {
        byte[] byArray = this.getCipher().doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    @NotNull
    public byte[] iv() {
        byte[] byArray = this.getCipher().getIV();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.iv");
        return byArray;
    }

    @NotNull
    public CipherInputStream createCipherInputStream(@NotNull String encryptedKey) {
        Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
        return new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)encryptedKey, (int)0)), this.getCipher());
    }

    @NotNull
    public CipherOutputStream createCipherOutputStream(@NotNull ByteArrayOutputStream byteArrayOutputStream) {
        Intrinsics.checkNotNullParameter((Object)byteArrayOutputStream, (String)"byteArrayOutputStream");
        return new CipherOutputStream(byteArrayOutputStream, this.getCipher());
    }
}

