/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.JWKInfo;
import com.liveperson.infra.otel.LPTelemetryAttributeKey;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.otel.models.OtlpAttribute;
import com.liveperson.infra.otel.models.OtlpValueData;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/infra/network/http/requests/JWKSRequest;", "Lcom/liveperson/infra/Command;", "domain", "", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/infra/model/JWKInfo;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lcom/liveperson/infra/ICallback;)V", "getCallback", "()Lcom/liveperson/infra/ICallback;", "getDomain", "()Ljava/lang/String;", "execute", "", "Companion", "infra_release"})
public final class JWKSRequest
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String domain;
    @NotNull
    private final ICallback<JWKInfo, Exception> callback;
    @NotNull
    private static final String TAG = "JWKSRequest";
    @NotNull
    private static final String LP_JWKS_URL = "https://%s/well-known/jwks";
    private static final int connectTimeout = 30000;
    private static final int readTimeout = 30000;
    private static final int sizeLimit = 300000;

    public JWKSRequest(@NotNull String domain, @NotNull ICallback<JWKInfo, Exception> callback2) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.domain = domain;
        this.callback = callback2;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final ICallback<JWKInfo, Exception> getCallback() {
        return this.callback;
    }

    @Override
    public void execute() {
        String string = LP_JWKS_URL;
        Object[] objectArray = new Object[]{this.domain};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String jwksUrl = string2;
        JWKSet jwkSet = null;
        List otlpAttributes = new ArrayList();
        otlpAttributes.add(new OtlpAttribute(LPTelemetryAttributeKey.URL_FULL.getValue(), new OtlpValueData.StringValue(jwksUrl)));
        otlpAttributes.add(new OtlpAttribute(LPTelemetryAttributeKey.METHOD.getValue(), new OtlpValueData.StringValue("GET")));
        LPTraceSpan jwksSpan = LPTelemetryManager.INSTANCE.begin(LPTraceType.GET_JWKS_KEY_REQ, otlpAttributes);
        try {
            jwkSet = JWKSet.load((URL)new URL(jwksUrl), (int)30000, (int)30000, (int)300000);
        }
        catch (Exception e) {
            LPLog.INSTANCE.d(TAG, "Failed to load jwkSet from: " + jwksUrl);
            LPTraceSpan lPTraceSpan = jwksSpan;
            if (lPTraceSpan != null) {
                lPTraceSpan.cancel();
            }
            this.callback.onError((Exception)((Throwable)e));
        }
        if (jwkSet == null || jwkSet.size() <= 0) {
            LPLog.INSTANCE.d(TAG, "jwkSet is blank");
            LPTraceSpan lPTraceSpan = jwksSpan;
            if (lPTraceSpan != null) {
                lPTraceSpan.cancel();
            }
            this.callback.onSuccess(null);
            return;
        }
        String kId = ((JWK)jwkSet.getKeys().get(0)).getKeyID();
        JWK jwk = jwkSet.getKeyByKeyId(kId);
        LPTraceSpan lPTraceSpan = jwksSpan;
        if (lPTraceSpan != null) {
            lPTraceSpan.end();
        }
        Intrinsics.checkNotNullExpressionValue((Object)jwk, (String)"jwk");
        Intrinsics.checkNotNullExpressionValue((Object)kId, (String)"kId");
        this.callback.onSuccess(new JWKInfo(jwk, kId));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/network/http/requests/JWKSRequest$Companion;", "", "()V", "LP_JWKS_URL", "", "TAG", "connectTimeout", "", "readTimeout", "sizeLimit", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

