/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.otel;

import com.liveperson.infra.otel.OtelUtils;
import com.liveperson.infra.otel.models.OtlpResource;
import com.liveperson.infra.otel.models.OtlpResourceSpan;
import com.liveperson.infra.otel.models.OtlpScope;
import com.liveperson.infra.otel.models.OtlpScopeSpan;
import com.liveperson.infra.otel.models.OtlpSpan;
import com.liveperson.infra.otel.models.OtlpTraceSpan;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/infra/otel/OtelUtils;", "", "()V", "SPAN_KIND_CLIENT", "", "createTrace", "Lcom/liveperson/infra/otel/models/OtlpTraceSpan;", "resource", "Lcom/liveperson/infra/otel/models/OtlpResource;", "sortedSpans", "", "Lcom/liveperson/infra/otel/models/OtlpSpan;", "extractDomain", "", "url", "extractSamplingFromDomain", "domain", "generateRandomHexString", "length", "generateSpanId", "generateTraceId", "getNanoTime", "", "infra_release"})
@SourceDebugExtension(value={"SMAP\nOtelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtelUtils.kt\ncom/liveperson/infra/otel/OtelUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class OtelUtils {
    @NotNull
    public static final OtelUtils INSTANCE = new OtelUtils();
    public static final int SPAN_KIND_CLIENT = 3;

    private OtelUtils() {
    }

    @NotNull
    public final String generateTraceId() {
        return this.generateRandomHexString(32);
    }

    @NotNull
    public final String generateSpanId() {
        return this.generateRandomHexString(16);
    }

    private final String generateRandomHexString(int length) {
        byte[] randomBytes = new byte[length / 2];
        Random random = new Random();
        random.nextBytes(randomBytes);
        return ArraysKt.joinToString$default((byte[])randomBytes, (CharSequence)"", null, null, (int)0, null, (Function1)generateRandomHexString.1.INSTANCE, (int)30, null);
    }

    public final long getNanoTime() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int extractSamplingFromDomain(@NotNull String domain) {
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Regex regex = new Regex("/(\\d{1,3})");
        MatchResult matchResult2 = matchResult = Regex.find$default((Regex)regex, (CharSequence)domain, (int)0, (int)2, null);
        Object object = matchResult2;
        if (matchResult2 == null) return 0;
        List list = object.getGroupValues();
        object = list;
        if (list == null) return 0;
        String string = (String)CollectionsKt.getOrNull((List)object, (int)1);
        object = string;
        if (string == null) return 0;
        Integer n = StringsKt.toIntOrNull((String)object);
        object = n;
        if (n == null) return 0;
        Object object2 = object;
        int it = ((Number)object2).intValue();
        boolean bl = false;
        if (1 > it) return 0;
        if (it >= 101) return 0;
        boolean bl2 = true;
        if (!bl2) return 0;
        Object object3 = object2;
        object = object3;
        if (object3 == null) return 0;
        int n2 = (Integer)object;
        return n2;
    }

    @NotNull
    public final String extractDomain(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Regex regex = new Regex("(https?://)?([^/]+)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)url, (int)0, (int)2, null);
        System.currentTimeMillis();
        Object object = matchResult;
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)CollectionsKt.getOrNull((List)object, (int)2)) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final OtlpTraceSpan createTrace(@NotNull OtlpResource resource, @NotNull List<OtlpSpan> sortedSpans) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter(sortedSpans, (String)"sortedSpans");
        OtlpScope scope = new OtlpScope("android.mobile.traces", "1.0.0");
        List scopeSpans = CollectionsKt.listOf((Object)new OtlpScopeSpan(scope, sortedSpans));
        OtlpResourceSpan resourceSpan = new OtlpResourceSpan(scopeSpans, resource);
        return new OtlpTraceSpan(CollectionsKt.listOf((Object)resourceSpan));
    }
}

