/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.log.LPLog;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006J\u001c\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/liveperson/infra/preferences/LogPreferences;", "", "()V", "preferences", "Landroid/content/SharedPreferences;", "buildKey", "", "brandId", "logServiceType", "clearAll", "", "getLogsFromPreferences", "", "key", "initialize", "applicationContext", "Landroid/content/Context;", "removeLogsFromPreferences", "storeLogsInPreferences", "logs", "Ljava/util/HashSet;", "Companion", "infra_release"})
public class LogPreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SharedPreferences preferences;
    @NotNull
    private static final String TAG = "LogPreferences";
    @NotNull
    public static final String LP_LOG_SHARED_PREF_FILENAME = "lp_log_shared_pref";

    public final void initialize(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (this.preferences == null) {
            LPLog.INSTANCE.i(TAG, "Initializing log preferences....");
            this.preferences = applicationContext.getSharedPreferences(LP_LOG_SHARED_PREF_FILENAME, 0);
        }
    }

    public final void storeLogsInPreferences(@NotNull String key, @NotNull HashSet<String> logs) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(logs, (String)"logs");
            LPLog.INSTANCE.d(TAG, "Storing logs in preferences");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putStringSet(key, (Set)logs)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @Nullable
    public final Set<String> getLogsFromPreferences(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LPLog.INSTANCE.d(TAG, "Return logs from preferences");
        SharedPreferences sharedPreferences = this.preferences;
        return sharedPreferences != null ? sharedPreferences.getStringSet(key, null) : null;
    }

    public final void removeLogsFromPreferences(@NotNull String key) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            LPLog.INSTANCE.d(TAG, "Clear logs from preferences for a key: {" + key + "}");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.remove(key)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @NotNull
    public final String buildKey(@NotNull String brandId, @NotNull String logServiceType) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)logServiceType, (String)"logServiceType");
        return logServiceType + "::" + brandId;
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "Clear all logs from preferences");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/infra/preferences/LogPreferences$Companion;", "", "()V", "LP_LOG_SHARED_PREF_FILENAME", "", "TAG", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

