/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.Event;
import com.liveperson.infra.html.HtmlUtils;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.md.MarkdownUtils;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.model.types.NotificationType;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.utils.LinkUtils;
import com.liveperson.infra.utils.markdown.HyperLinkUtils;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessageParser {
    private static final String TAG = PushMessageParser.class.getSimpleName();
    private static final String KEY_PAYLOAD = "payload";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_TITLE = "title";
    private static final String KEY_BACKEND_SERVICE = "backendService";
    private static final String KEY_COLLAPSE = "collapse_key";
    private static final String KEY_CONVERSATION_ID = "conversationId";
    private static final String KEY_LE_ENGAGEMENT_ID = "leEngagementId";
    private static final String KEY_LE_CAMPAIGN_ID = "leCampaignId";
    private static final String KEY_IS_OUTBOUND_PUSH = "isProactivePush";
    private static final String KEY_LOOK_BACK_PERIOD = "lookBackPeriod";
    private static final String KEY_AGENT_PID = "agentPid";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_BADGE_UNREAD_COUNTER = "badge";
    private static final String KEY_C2M_BACKEND = "c2m";
    private static final String KEY_EVENT = "event";
    private static final String KEY_EXPIRATION_EPOCH_TIME = "expirationEpochTime";
    private static final String KEY_DATE_CREATED = "dateCreated";
    private static final String VAL_PRMSG_BACKEND = "prmsg";
    private static final String DELIMITER = ":";

    @Nullable
    public static PushMessage parse(String brandId, Context context, Map<String, String> remoteMessage) {
        try {
            Bundle pushMessageBundle = PushMessageParser.convertDataToBundle(remoteMessage);
            return PushMessageParser.parsePushMessage(brandId, context, pushMessageBundle);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010A, "Push message parsing error", e);
            return null;
        }
    }

    @NonNull
    @VisibleForTesting
    static PushMessage parsePushMessage(String brandId, Context context, Bundle pushMessageBundle) throws JSONException {
        String collapseKey = pushMessageBundle.getString(KEY_COLLAPSE);
        String originMessage = pushMessageBundle.getString(KEY_MESSAGE);
        String splitMessage = "";
        String title = pushMessageBundle.getString(KEY_TITLE);
        String from = "";
        if (!TextUtils.isEmpty((CharSequence)originMessage)) {
            int splitPoint = originMessage.indexOf(DELIMITER);
            if (splitPoint != -1) {
                from = originMessage.substring(0, splitPoint).trim();
                splitMessage = originMessage.substring(splitPoint + DELIMITER.length()).trim();
                if (LinkUtils.containsMarkdownHyperlink(splitMessage)) {
                    splitMessage = HyperLinkUtils.buildMessageString(splitMessage);
                }
            } else {
                splitMessage = originMessage;
            }
        }
        PushMessage pushMessage = new PushMessage(brandId, from, splitMessage);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            pushMessage.setTitle(title);
        }
        pushMessage.setCollapseKey(collapseKey);
        String payLoadString = pushMessageBundle.getString(KEY_PAYLOAD);
        String conversationId = "";
        String backendService = "";
        String engagementId = "";
        String campaignId = "";
        boolean isOutboundPush = false;
        String lookBackPeriod = "";
        String agentPid = "";
        String transactionId = "";
        long expirationEpochTime = 0L;
        if (!TextUtils.isEmpty((CharSequence)payLoadString)) {
            JSONObject payLoadJson = new JSONObject(payLoadString);
            conversationId = payLoadJson.optString(KEY_CONVERSATION_ID);
            backendService = payLoadJson.optString(KEY_BACKEND_SERVICE);
            engagementId = payLoadJson.optString(KEY_LE_ENGAGEMENT_ID);
            campaignId = payLoadJson.optString(KEY_LE_CAMPAIGN_ID);
            isOutboundPush = payLoadJson.optBoolean(KEY_IS_OUTBOUND_PUSH);
            if (!isOutboundPush && backendService.equals(KEY_C2M_BACKEND)) {
                isOutboundPush = true;
            }
            lookBackPeriod = payLoadJson.optString(KEY_LOOK_BACK_PERIOD);
            agentPid = payLoadJson.optString(KEY_AGENT_PID);
            transactionId = payLoadJson.optString(KEY_TRANSACTION_ID);
            String messageEvent = payLoadJson.optString(KEY_EVENT);
            expirationEpochTime = payLoadJson.optLong(KEY_EXPIRATION_EPOCH_TIME);
            String unreadCounter = payLoadJson.optString(KEY_BADGE_UNREAD_COUNTER);
            if (!TextUtils.isEmpty((CharSequence)unreadCounter) && TextUtils.isDigitsOnly((CharSequence)unreadCounter)) {
                pushMessage.setCurrentUnreadMessagesCounter(Integer.parseInt(unreadCounter));
            }
            if (!TextUtils.isEmpty((CharSequence)messageEvent)) {
                pushMessage.setMessageEvent(messageEvent);
            }
        }
        pushMessage.setConversationId(conversationId);
        pushMessage.setBackendService(backendService);
        pushMessage.setTransactionId(transactionId);
        pushMessage.setExpirationEpochTime(expirationEpochTime);
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            pushMessage.setPushMessageId(transactionId);
        }
        if (!TextUtils.isEmpty((CharSequence)engagementId) && !TextUtils.isEmpty((CharSequence)campaignId)) {
            if (isOutboundPush) {
                pushMessage.setNotificationType(NotificationType.C2M);
                if (VAL_PRMSG_BACKEND.equalsIgnoreCase(backendService)) {
                    pushMessage.setNotificationType(NotificationType.PROACTIVE);
                }
            }
            pushMessage.setMessage(originMessage);
            String nonTagMessage = PushMessageParser.parseHtmlContent(originMessage);
            pushMessage.setFrom("");
            pushMessage.setCampaignInfo(new CampaignInfo(Long.valueOf(campaignId), Long.valueOf(engagementId), isOutboundPush));
            if (!TextUtils.isEmpty((CharSequence)lookBackPeriod)) {
                pushMessage.setLookBackPeriod(Long.valueOf(lookBackPeriod));
            }
            pushMessage.setAgentPid(agentPid);
            if (context != null) {
                PushMessagePreferences.INSTANCE.init(context.getApplicationContext());
                PushMessagePreferences.INSTANCE.setCachedPushMessage(brandId, pushMessage);
                Infra.instance.getEventManagerService().logEvent(brandId, transactionId, true, Event.DELIVERY, null, null, context.getApplicationContext());
            }
            pushMessage.setMessage(nonTagMessage);
        }
        return pushMessage;
    }

    @VisibleForTesting
    static String parseHtmlContent(String message) {
        String htmlMessage;
        try {
            htmlMessage = MarkdownUtils.markdownToHtml(message);
        }
        catch (Throwable exception) {
            LPLog.INSTANCE.d(TAG, "Failed to parse markdown", exception);
            htmlMessage = message;
        }
        return HtmlUtils.convertHtmlToStyledString(htmlMessage).toString();
    }

    @NonNull
    public static ArrayList<PushMessage> parsePendingProactiveMessages(String brandId, Context context, String jsonString) {
        ArrayList<PushMessage> pushMessageList = new ArrayList<PushMessage>();
        try {
            JSONObject root = new JSONObject(jsonString);
            JSONArray messages = root.getJSONArray("messages");
            if (messages == null) {
                return pushMessageList;
            }
            PushMessagePreferences.INSTANCE.init(context);
            PushMessagePreferences.INSTANCE.clearAll();
            for (int i = 0; i < messages.length(); ++i) {
                PushMessage pushMessage = PushMessageParser.parseProactiveData(brandId, context, messages.getJSONObject(i));
                if (pushMessage == null) continue;
                pushMessageList.add(pushMessage);
            }
        }
        catch (JSONException ex) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016I, "Failed to parse proactive messages", ex);
            return pushMessageList;
        }
        return pushMessageList;
    }

    @VisibleForTesting
    static PushMessage parseProactiveData(String brandId, Context applicationContext, JSONObject messageJson) {
        PushMessage pushMessage;
        if (messageJson == null) {
            return null;
        }
        try {
            JSONObject data = messageJson.getJSONObject("data");
            String payloadStr = data.getString(KEY_PAYLOAD);
            JSONObject payload = new JSONObject(payloadStr);
            String message = data.getString(KEY_MESSAGE);
            String conversationId = payload.optString(KEY_CONVERSATION_ID);
            String backendService = payload.optString(KEY_BACKEND_SERVICE);
            String engagementId = payload.optString(KEY_LE_ENGAGEMENT_ID);
            String campaignId = payload.optString(KEY_LE_CAMPAIGN_ID);
            boolean isOutboundPush = payload.optBoolean(KEY_IS_OUTBOUND_PUSH);
            if (!isOutboundPush && backendService.equals(KEY_C2M_BACKEND)) {
                isOutboundPush = true;
            }
            String lookBackPeriod = payload.optString(KEY_LOOK_BACK_PERIOD);
            String agentPid = payload.optString(KEY_AGENT_PID);
            String transactionId = payload.optString(KEY_TRANSACTION_ID);
            String messageEvent = payload.optString(KEY_EVENT);
            long expirationEpochTime = payload.optLong(KEY_EXPIRATION_EPOCH_TIME);
            long dateCreated = payload.optLong(KEY_DATE_CREATED);
            pushMessage = new PushMessage(brandId, "", message, dateCreated);
            if (!TextUtils.isEmpty((CharSequence)messageEvent)) {
                pushMessage.setMessageEvent(messageEvent);
            }
            pushMessage.setConversationId(conversationId);
            pushMessage.setBackendService(backendService);
            pushMessage.setTransactionId(transactionId);
            pushMessage.setPushMessageId(transactionId);
            pushMessage.setAgentPid(agentPid);
            pushMessage.setExpirationEpochTime(expirationEpochTime);
            if (!TextUtils.isEmpty((CharSequence)engagementId) && !TextUtils.isEmpty((CharSequence)campaignId)) {
                if (isOutboundPush) {
                    pushMessage.setNotificationType(NotificationType.C2M);
                    if (VAL_PRMSG_BACKEND.equalsIgnoreCase(backendService)) {
                        pushMessage.setNotificationType(NotificationType.PROACTIVE);
                    }
                }
                pushMessage.setCampaignInfo(new CampaignInfo(Long.valueOf(campaignId), Long.valueOf(engagementId), isOutboundPush));
                String nonTagMessage = message;
                if (LinkUtils.containsMarkdownHyperlink(message)) {
                    nonTagMessage = HyperLinkUtils.buildMessageString(message);
                }
                if (!TextUtils.isEmpty((CharSequence)lookBackPeriod)) {
                    pushMessage.setLookBackPeriod(Long.valueOf(lookBackPeriod));
                }
                if (applicationContext != null) {
                    PushMessagePreferences.INSTANCE.init(applicationContext);
                    PushMessagePreferences.INSTANCE.setCachedPushMessage(brandId, pushMessage);
                    Infra.instance.getEventManagerService().logEvent(brandId, transactionId, true, Event.DELIVERY, null, null, applicationContext);
                }
                pushMessage.setMessage(nonTagMessage);
            }
        }
        catch (JSONException ex) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016I, "Failed to parse proactive data", ex);
            return null;
        }
        return pushMessage;
    }

    public static Bundle convertDataToBundle(Map<String, String> data) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static PushMessage parseBundle(String brandId, Context context, Bundle data) {
        try {
            return PushMessageParser.parsePushMessage(brandId, context, data);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010B, "Push message parsing error", e);
            return null;
        }
    }
}

