/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import com.liveperson.infra.Infra;
import java.util.ArrayList;

public class Synchronizer<T> {
    private boolean hasBeenCanceled;
    private int holdersCount = 0;
    private final SynchronizerCallback<T> futureTask;
    private ArrayList<T> allHoldersResults;

    public Synchronizer(SynchronizerCallback<T> lastAction) {
        this.futureTask = lastAction;
        this.allHoldersResults = new ArrayList();
        this.hasBeenCanceled = false;
    }

    public Holder createHolder() {
        ++this.holdersCount;
        return new Holder();
    }

    public static interface SynchronizerCallback<T> {
        public void done(ArrayList<T> var1);
    }

    public class Holder {
        private boolean isReleased = false;

        private Holder() {
        }

        public void release() {
            this.release(null);
        }

        public void release(T extra) {
            this.release(extra, false);
        }

        private void release(T extra, boolean afterDelay) {
            if (Synchronizer.this.hasBeenCanceled) {
                return;
            }
            if (this.isReleased) {
                return;
            }
            if (Synchronizer.this.holdersCount == 1 && !afterDelay) {
                Infra.instance.getApplicationHandler().postDelayed(() -> this.release(extra, true), 100L);
                return;
            }
            this.isReleased = true;
            Synchronizer.this.allHoldersResults.add(extra);
            --Synchronizer.this.holdersCount;
            if (Synchronizer.this.holdersCount == 0) {
                Synchronizer.this.futureTask.done(Synchronizer.this.allHoldersResults);
            }
        }
    }
}

