@file:JvmName("MarkdownUtils")

package com.liveperson.infra.md

import java.util.regex.Pattern

private const val HTML_LINK_FORMAT = "<font color=\"%s\"><a href=\"%s\">%s</a></font>"
private const val HTML_LINK_FORMAT_NO_COLOR = "<a href=\"%s\">%s</a></font>"
private const val MARKDOWN_REGEX = "#md#\\[(?<text>(?:(?!#/?md).)+)\\]\\((?<link>(?:(?!#/?md).)+)\\)#/md#"

/**
 * Utility method used to convert text with md links to
 * html links to apply link spans to text.
 *
 * Note: this method is used as a replacement for existed [HyperLinkUtils] methods
 * to extract links and apply clickable spans to it.
 *
 * Note: you need to apply Html.fromHtml() to apply links correctly in text view.
 */
fun String.convertMarkdownToHTML(color: Int): String {
    val regex = Pattern.compile(MARKDOWN_REGEX)
    val matcher = regex.matcher(this)
    var result = this
    val hexColor = String.format("#%06X", (0xFFFFFF and color))
    while (matcher.find()) {
        val text = matcher.group(1)
        val link = matcher.group(2)
        val htmlLink = HTML_LINK_FORMAT.format(hexColor, link, text)
        result = result.replaceFirst(matcher.group(0)!!, htmlLink)
    }
    return result
}

fun String.markdownToHtml(): String {
    val regex = Pattern.compile(MARKDOWN_REGEX)
    val matcher = regex.matcher(this)
    var result = this
    while (matcher.find()) {
        val text = matcher.group(1)
        val link = matcher.group(2)
        val htmlLink = HTML_LINK_FORMAT_NO_COLOR.format(link, text)
        result = result.replaceFirst(matcher.group(0)!!, htmlLink)
    }
    return result
}