/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.html.tag;

import android.text.Editable;
import android.text.Html;
import android.text.Spannable;
import android.text.Spanned;
import com.liveperson.infra.html.tag.BulletListItem;
import com.liveperson.infra.html.tag.Mark;
import com.liveperson.infra.html.tag.NumberListItem;
import com.liveperson.infra.html.tag.TextLeadingMarginSpan;
import java.util.Collection;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/html/tag/ListTagHandler;", "Landroid/text/Html$TagHandler;", "()V", "lists", "Ljava/util/Stack;", "Lcom/liveperson/infra/html/tag/ListTagHandler$ListTag;", "handleTag", "", "opening", "", "tag", "", "output", "Landroid/text/Editable;", "xmlReader", "Lorg/xml/sax/XMLReader;", "Companion", "ListTag", "Ol", "Ul", "infra_release"})
@SourceDebugExtension(value={"SMAP\nListTagHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class ListTagHandler
implements Html.TagHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Stack<ListTag> lists = new Stack();
    private static final int GAP_WIDTH = 50;

    public void handleTag(boolean opening, @NotNull String tag, @NotNull Editable output, @NotNull XMLReader xmlReader) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)xmlReader, (String)"xmlReader");
        switch (tag) {
            case "unordered": {
                Stack<ListTag> stack;
                if (opening) {
                    this.lists.push(new Ul());
                    break;
                }
                Stack<ListTag> it = stack = this.lists;
                boolean bl = false;
                Stack<ListTag> stack2 = !((Collection)it).isEmpty() ? stack : null;
                if (stack2 != null) {
                    stack2.pop();
                }
                break;
            }
            case "ordered": {
                Stack<ListTag> stack;
                if (opening) {
                    this.lists.push(new Ol());
                    break;
                }
                Stack<ListTag> it = stack = this.lists;
                boolean bl = false;
                Stack<ListTag> stack3 = !((Collection)it).isEmpty() ? stack : null;
                if (stack3 != null) {
                    stack3.pop();
                }
                break;
            }
            case "listitem": {
                Stack<ListTag> stack;
                if (opening) {
                    Stack<ListTag> stack4;
                    Stack<ListTag> it = stack4 = this.lists;
                    boolean bl = false;
                    Stack<ListTag> stack5 = !((Collection)it).isEmpty() ? stack4 : null;
                    if (stack5 != null && (stack5 = stack5.peek()) != null) {
                        stack5.openItem(output);
                    }
                    break;
                }
                Stack<ListTag> it = stack = this.lists;
                boolean bl = false;
                Stack<ListTag> stack6 = !((Collection)it).isEmpty() ? stack : null;
                if (stack6 == null || (stack6 = stack6.peek()) == null) break;
                stack6.closeItem(output, this.lists.size() - 1);
                break;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\t\u001a\u0004\u0018\u0001H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0082\b\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/infra/html/tag/ListTagHandler$Companion;", "", "()V", "GAP_WIDTH", "", "appendNewLine", "", "text", "Landroid/text/Editable;", "getLast", "T", "Lcom/liveperson/infra/html/tag/Mark;", "Landroid/text/Spanned;", "(Landroid/text/Spanned;)Lcom/liveperson/infra/html/tag/Mark;", "setSpanFromMark", "Landroid/text/Spannable;", "mark", "styleSpan", "start", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void appendNewLine(Editable text) {
            if (((CharSequence)text).length() > 0 && StringsKt.last((CharSequence)((CharSequence)text)) != '\n') {
                text.append((CharSequence)"\n");
            }
        }

        private final /* synthetic */ <T extends Mark> T getLast(Spanned text) {
            boolean $i$f$getLast = false;
            int n = text.length();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object[] objectArray = text.getSpans(0, n, Mark.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"text.getSpans(0, text.length, T::class.java)");
            return (T)((Mark)ArraysKt.lastOrNull((Object[])objectArray));
        }

        private final void setSpanFromMark(Spannable text, Mark mark, Object styleSpan) {
            int markerLocation = text.getSpanStart((Object)mark);
            text.removeSpan((Object)mark);
            int end = text.length();
            if (markerLocation != end) {
                text.setSpan(styleSpan, markerLocation, end, 33);
            }
        }

        private final void start(Spannable text, Mark mark) {
            int currentPosition = text.length();
            text.setSpan((Object)mark, currentPosition, currentPosition, 17);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/liveperson/infra/html/tag/ListTagHandler$ListTag;", "", "closeItem", "", "text", "Landroid/text/Editable;", "indentation", "", "openItem", "infra_release"})
    private static interface ListTag {
        public void openItem(@NotNull Editable var1);

        public void closeItem(@NotNull Editable var1, int var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/liveperson/infra/html/tag/ListTagHandler$Ol;", "Lcom/liveperson/infra/html/tag/ListTagHandler$ListTag;", "()V", "index", "", "closeItem", "", "text", "Landroid/text/Editable;", "indentation", "openItem", "infra_release"})
    @SourceDebugExtension(value={"SMAP\nListTagHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Ol\n+ 2 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Companion\n*L\n1#1,157:1\n130#2:158\n*S KotlinDebug\n*F\n+ 1 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Ol\n*L\n98#1:158\n*E\n"})
    private static final class Ol
    implements ListTag {
        private int index = 1;

        @Override
        public void openItem(@NotNull Editable text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Companion.appendNewLine(text);
            Companion.start((Spannable)text, new NumberListItem(this.index));
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public void closeItem(@NotNull Editable text, int indentation) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Companion.appendNewLine(text);
                Companion this_$iv = Companion;
                boolean $i$f$getLast = false;
                Object[] objectArray = ((Spanned)text).getSpans(0, ((Spanned)text).length(), NumberListItem.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"text.getSpans(0, text.length, T::class.java)");
                NumberListItem numberListItem = (NumberListItem)((Mark)ArraysKt.lastOrNull((Object[])objectArray));
                if (numberListItem == null) break block0;
                NumberListItem mark = numberListItem;
                boolean bl = false;
                Companion.setSpanFromMark((Spannable)text, mark, new TextLeadingMarginSpan(50, indentation, mark.getNumber() + "."));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/html/tag/ListTagHandler$Ul;", "Lcom/liveperson/infra/html/tag/ListTagHandler$ListTag;", "()V", "closeItem", "", "text", "Landroid/text/Editable;", "indentation", "", "openItem", "infra_release"})
    @SourceDebugExtension(value={"SMAP\nListTagHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Ul\n+ 2 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Companion\n*L\n1#1,157:1\n130#2:158\n*S KotlinDebug\n*F\n+ 1 ListTagHandler.kt\ncom/liveperson/infra/html/tag/ListTagHandler$Ul\n*L\n76#1:158\n*E\n"})
    private static final class Ul
    implements ListTag {
        @Override
        public void openItem(@NotNull Editable text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Companion.appendNewLine(text);
            Companion.start((Spannable)text, new BulletListItem());
        }

        @Override
        public void closeItem(@NotNull Editable text, int indentation) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Companion.appendNewLine(text);
                Companion this_$iv = Companion;
                boolean $i$f$getLast = false;
                Object[] objectArray = ((Spanned)text).getSpans(0, ((Spanned)text).length(), BulletListItem.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"text.getSpans(0, text.length, T::class.java)");
                BulletListItem bulletListItem = (BulletListItem)((Mark)ArraysKt.lastOrNull((Object[])objectArray));
                if (bulletListItem == null) break block0;
                BulletListItem mark = bulletListItem;
                boolean bl = false;
                Companion.setSpanFromMark((Spannable)text, mark, new TextLeadingMarginSpan(50, indentation, " \u2022"));
            }
        }
    }
}

