/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.QuickReplyStyle;
import org.json.JSONArray;
import org.json.JSONException;

public final class MessageOption
implements Parcelable {
    private static final String TAG = "MessageOption";
    private String displayText;
    private String value;
    private JSONArray metadata;
    private QuickReplyStyle style;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public MessageOption createFromParcel(Parcel in) {
            return new MessageOption(in);
        }

        public MessageOption[] newArray(int size) {
            return new MessageOption[size];
        }
    };

    public MessageOption(@NonNull String displayText, @NonNull String value) {
        this.displayText = displayText;
        this.value = value.trim().length() == 0 ? displayText : value;
    }

    public MessageOption(@NonNull String displayText, @NonNull String value, JSONArray metadata) {
        this(displayText, value);
        this.metadata = metadata;
    }

    public MessageOption(@NonNull String displayText, @NonNull String value, JSONArray metadata, QuickReplyStyle style) {
        this(displayText, value);
        this.metadata = metadata;
        this.style = style;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getValue() {
        return this.value;
    }

    public JSONArray getMetadata() {
        return this.metadata;
    }

    private MessageOption(Parcel in) {
        this.displayText = in.readString();
        this.value = in.readString();
        String metadataString = in.readString();
        if (!TextUtils.isEmpty((CharSequence)metadataString)) {
            try {
                this.metadata = new JSONArray(metadataString);
            }
            catch (JSONException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000043, "Failed to parse JSON.", e);
            }
        }
        this.style = (QuickReplyStyle)in.readParcelable(QuickReplyStyle.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.displayText);
        dest.writeString(this.value);
        dest.writeString(this.metadata == null ? "" : this.metadata.toString());
        dest.writeParcelable((Parcelable)this.style, flags);
    }

    @Nullable
    public QuickReplyStyle getStyle() {
        return this.style;
    }

    public void setStyle(QuickReplyStyle style) {
        this.style = style;
    }
}

