/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.markdown;

import android.text.SpannableStringBuilder;
import androidx.annotation.ColorInt;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.markdown.HyperlinkClickableSpan;
import com.liveperson.infra.utils.markdown.MarkdownHyperlinkItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Please, use markdown utils class for it")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/utils/markdown/HyperLinkUtils;", "", "()V", "TAG", "", "buildFormattedMessage", "Landroid/text/SpannableStringBuilder;", "message", "", "hyperlinkList", "", "Lcom/liveperson/infra/utils/markdown/MarkdownHyperlinkItem;", "hyperLinkColor", "", "buildHyperlinkList", "buildMessageString", "infra_release"})
public final class HyperLinkUtils {
    @NotNull
    public static final HyperLinkUtils INSTANCE = new HyperLinkUtils();
    @NotNull
    private static final String TAG = "HyperLinkUtils";

    private HyperLinkUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<MarkdownHyperlinkItem> buildHyperlinkList(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List tempHyperlinkList = new ArrayList();
        boolean indexInsideTag = false;
        int index = 0;
        while (index <= message.length() - 5) {
            MarkdownHyperlinkItem linkItem;
            if (!indexInsideTag) {
                String string = message.substring(index, index + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string, (Object)"#md#")) {
                    linkItem = new MarkdownHyperlinkItem();
                    linkItem.setStart(index);
                    tempHyperlinkList.add(linkItem);
                    indexInsideTag = true;
                    index += 4;
                    continue;
                }
            }
            if (indexInsideTag) {
                String string = message.substring(index, index + 5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string, (Object)"#/md#")) {
                    linkItem = (MarkdownHyperlinkItem)CollectionsKt.last((List)tempHyperlinkList);
                    linkItem.setEnd(index += 5);
                    linkItem.buildHyperlinkItem(message);
                    indexInsideTag = false;
                    continue;
                }
            }
            ++index;
        }
        List hyperlinkList = new ArrayList();
        for (MarkdownHyperlinkItem item : tempHyperlinkList) {
            if (item.isValid()) {
                hyperlinkList.add(item);
                continue;
            }
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000149, "Invalid markdown hyperlink format.");
        }
        return hyperlinkList;
    }

    @JvmStatic
    @NotNull
    public static final SpannableStringBuilder buildFormattedMessage(@NotNull CharSequence message, @NotNull List<MarkdownHyperlinkItem> hyperlinkList, @ColorInt int hyperLinkColor) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(hyperlinkList, (String)"hyperlinkList");
        SpannableStringBuilder formattedMessage = new SpannableStringBuilder();
        int linkItemIndex = 0;
        int index = 0;
        while (index < message.length()) {
            if (linkItemIndex < hyperlinkList.size()) {
                MarkdownHyperlinkItem linkItem = hyperlinkList.get(linkItemIndex);
                String textBeforeOpenTag = ((Object)message.subSequence(index, linkItem.getStart())).toString();
                formattedMessage.append((CharSequence)textBeforeOpenTag);
                String title = linkItem.getTitle();
                formattedMessage.append((CharSequence)title);
                HyperlinkClickableSpan hyperlinkClickableSpan = new HyperlinkClickableSpan(linkItem.getLink(), hyperLinkColor);
                int n = formattedMessage.length();
                String string = title;
                Intrinsics.checkNotNull((Object)string);
                formattedMessage.setSpan((Object)hyperlinkClickableSpan, n - string.length(), formattedMessage.length(), 33);
                ++linkItemIndex;
                index = linkItem.getEnd();
                continue;
            }
            CharSequence charSequence = message;
            int n = charSequence.length();
            formattedMessage.append((CharSequence)((Object)charSequence.subSequence(index, n)).toString());
            break;
        }
        return formattedMessage;
    }

    @JvmStatic
    @NotNull
    public static final String buildMessageString(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<MarkdownHyperlinkItem> hyperlinkList = HyperLinkUtils.buildHyperlinkList(message);
        StringBuilder messageBuilder = new StringBuilder();
        int linkItemIndex = 0;
        int index = 0;
        while (index < message.length()) {
            if (linkItemIndex < hyperlinkList.size()) {
                String textBeforeOpenTag;
                MarkdownHyperlinkItem linkItem = hyperlinkList.get(linkItemIndex);
                Intrinsics.checkNotNullExpressionValue((Object)message.substring(index, linkItem.getStart()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                messageBuilder.append(textBeforeOpenTag).append(linkItem.getTitle());
                ++linkItemIndex;
                index = linkItem.getEnd();
                continue;
            }
            String string = message.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            messageBuilder.append(string);
            break;
        }
        String string = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageBuilder.toString()");
        return string;
    }
}

