/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.database.SQLException;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class DataBaseExecutor {
    private static final String TAG = "DataBaseExecutor";
    private static final ThreadFactory threadFactory = r -> {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        Thread thread = new Thread(group, r, TAG, 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    };
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(threadFactory);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void recreateServiceIfTerminated() {
        if (!service.isTerminated() && !service.isShutdown()) return;
        Class<DataBaseExecutor> clazz = DataBaseExecutor.class;
        synchronized (DataBaseExecutor.class) {
            service = Executors.newSingleThreadScheduledExecutor(threadFactory);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void execute(Runnable runnable) {
        try {
            DataBaseExecutor.recreateServiceIfTerminated();
            Runnable newRunnable = () -> {
                if (Thread.interrupted()) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable throwbale) {
                    LPLog.INSTANCE.d(TAG, "Exception occured in database command", throwbale);
                }
            };
            if (Thread.currentThread().getName().equals(TAG)) {
                newRunnable.run();
            } else {
                service.execute(newRunnable);
            }
        }
        catch (SQLException | RejectedExecutionException exception) {
            LPLog.INSTANCE.d(TAG, "Failed to run database command", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void killAll(ICallback<Void, Exception> callback2) {
        try {
            if (service.isShutdown() || service.isTerminated()) {
                callback2.onSuccess(null);
                return;
            }
            Class<DataBaseExecutor> clazz = DataBaseExecutor.class;
            synchronized (DataBaseExecutor.class) {
                service.shutdownNow();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception exception) {
            callback2.onError(exception);
        }
    }
}

