/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.analytics.events;

import android.content.Context;
import com.liveperson.infra.PushType;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.analytics.AnalyticsService;
import com.liveperson.infra.analytics.EventName;
import com.liveperson.infra.analytics.EventProperty;
import com.liveperson.infra.analytics.LPAPIVersion;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.log.LogLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u0000 N2\u00020\u0001:\u0001NB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J2\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u0015\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u0019\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u001a\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J<\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bJN\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0013J.\u0010&\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J \u0010'\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001a\u0010*\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\u0013H\u0016J.\u0010,\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010.\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016JD\u0010/\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00100\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u0001032\b\u0010\t\u001a\u0004\u0018\u00010\bJ$\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u00106\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\t\u001a\u0004\u0018\u00010\bJ<\u00107\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u0002092\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010:\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001c\u0010;\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u0010<\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010>\u001a\u00020\u0013H\u0016J\u001a\u0010?\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010@\u001a\u00020\u0013H\u0016J\u001c\u0010A\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010B\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010C\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J$\u0010D\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010E\u001a\u00020\u0013H\u0016J6\u0010F\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016JD\u0010G\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u0010K\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J,\u0010L\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J&\u0010M\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/liveperson/infra/analytics/events/LPAnalyticsFacade;", "", "analyticsService", "Lcom/liveperson/infra/analytics/AnalyticsService;", "(Lcom/liveperson/infra/analytics/AnalyticsService;)V", "trackCheckActiveConversation", "", "brandId", "", "error", "trackCheckAgentID", "trackCheckConversationIsMarkedAsUrgent", "trackClearHistory", "trackDisplayConversation", "version", "Lcom/liveperson/infra/analytics/LPAPIVersion;", "authType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "hasCampaignInfo", "", "isUsingFragment", "trackGetLogSnapshot", "logLevel", "Lcom/liveperson/infra/log/LogLevel;", "trackGetLogSnapshotBlock", "trackGetLogSnapshotString", "trackGetSDKVersion", "sdkVersion", "trackGetUnreadMessageCount", "hasAppId", "callBackAvailable", "trackHandlePushMessage", "appContext", "Landroid/content/Context;", "showNotification", "isOutboundCampaignPush", "backendService", "isProactiveRichContent", "trackHideConversation", "trackInit", "startUpTime", "", "trackIsDebuggable", "isDebuggable", "trackIsPusherRegistered", "hasDeviceToken", "trackLoggingClearHistory", "trackLogout", "executionTime", "forceLogOut", "type", "Lcom/liveperson/infra/PushUnregisterType;", "trackMarkConversation", "isUrgent", "trackReconnect", "trackRegisterLPPusher", "pushType", "Lcom/liveperson/infra/PushType;", "isPushTokenProvided", "trackResolveConversation", "trackSetCallback", "isListenerAvailable", "isSetCallback", "trackSetDataMasking", "dataMasking", "trackSetImageServiceDownloadNotificationBuilder", "trackSetImageServicePendingIntent", "trackSetImageServiceUploadNotificationBuilder", "trackSetLogLevel", "isLogDump", "trackSetPushNotificationTapped", "trackSetUserProfile", "hasFirstName", "hasLastName", "hasPhoneNumber", "trackShutdown", "trackUnRegisterPusher", "trackUpdateTokenInBackground", "Companion", "infra_release"})
@SourceDebugExtension(value={"SMAP\nLPAnalyticsFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPAnalyticsFacade.kt\ncom/liveperson/infra/analytics/events/LPAnalyticsFacade\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,510:1\n37#2,2:511\n37#2,2:513\n37#2,2:515\n*S KotlinDebug\n*F\n+ 1 LPAnalyticsFacade.kt\ncom/liveperson/infra/analytics/events/LPAnalyticsFacade\n*L\n146#1:511,2\n175#1:513,2\n386#1:515,2\n*E\n"})
public class LPAnalyticsFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsService analyticsService;
    @NotNull
    private static final String API_VERSION = "api_version";
    @NotNull
    private static final String STARTUP_TIME = "startup_time";
    @NotNull
    private static final String EXECUTION_TIME = "execution_time";
    @NotNull
    private static final String AUTH_TYPE = "auth_type";
    @NotNull
    private static final String HAS_CAMPAIGN_INFO = "has_campaign_info";
    @NotNull
    private static final String HAS_NOTIFICATION_TOKEN = "has_notification_token";
    @NotNull
    private static final String HAS_APP_ID = "has_app_id";
    @NotNull
    private static final String SHOW_NOTIFICATION = "show_notification";
    @NotNull
    private static final String IS_OUTBOUND_CAMPAIGN_PUSH = "is_outbound_campaign_push";
    @NotNull
    private static final String IS_PROACTIVE_RICH_CONTENT = "richContent";
    @NotNull
    private static final String BACKEND_SERVICE = "backend_service";
    @NotNull
    private static final String FORCE_LOGOUT = "force_logout";
    @NotNull
    private static final String PUSH_UNREGISTER_TYPE = "push_unregister_type";
    @NotNull
    private static final String PUSH_PLATFORM = "push_platform";
    @NotNull
    private static final String Error = "error";
    @NotNull
    private static final String DEBUGGABLE = "debuggable";
    @NotNull
    private static final String DATA_MASKING = "data_masking";
    @NotNull
    private static final String HAS_FIRST_NAME = "has_first_name";
    @NotNull
    private static final String HAS_LAST_NAME = "has_last_name";
    @NotNull
    private static final String HAS_PHONE_NUMBER = "has_phone_number";
    @NotNull
    private static final String HAS_CALLBACK = "is_callback_listener";
    @NotNull
    private static final String LOG_LEVEL = "log_level";
    @NotNull
    private static final String LP_SDK_VERSION = "lp_sdk_version";

    public LPAnalyticsFacade(@NotNull AnalyticsService analyticsService) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        this.analyticsService = analyticsService;
    }

    public final void trackInit(@NotNull LPAPIVersion version, long startUpTime, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(STARTUP_TIME, startUpTime), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.INITIALIZE, eventPropertyArray));
    }

    public final void trackDisplayConversation(@NotNull LPAPIVersion version, @Nullable LPAuthenticationType authType, boolean hasCampaignInfo, boolean isUsingFragment, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        EventName.LivePerson eventName = isUsingFragment ? EventName.LivePerson.SHOW_CONVERSATION_HOST_CONTROL : EventName.LivePerson.SHOW_CONVERSATION_LP_CONTROL;
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(HAS_CAMPAIGN_INFO, hasCampaignInfo), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)eventName, eventPropertyArray));
    }

    public final void trackRegisterLPPusher(@NotNull LPAPIVersion version, @Nullable String brandId, @NotNull PushType pushType, @Nullable LPAuthenticationType authType, boolean isPushTokenProvided, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)pushType), (String)"pushType");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(PUSH_PLATFORM, pushType.getPlatform()), new EventProperty(HAS_NOTIFICATION_TOKEN, isPushTokenProvided), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.REGISTER_PUSHER, eventPropertyArray));
    }

    public final void trackGetUnreadMessageCount(@NotNull LPAPIVersion version, @Nullable String brandId, boolean hasAppId, @Nullable LPAuthenticationType authType, boolean callBackAvailable, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(HAS_CALLBACK, callBackAvailable), new EventProperty(HAS_APP_ID, hasAppId), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_UNREAD_MESSAGES_COUNT, eventPropertyArray));
    }

    public final void trackReconnect(@NotNull LPAPIVersion version, @Nullable String brandId, @Nullable LPAuthenticationType authType, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.RECONNECT, eventPropertyArray));
    }

    public final void trackLogout(@NotNull LPAPIVersion version, @Nullable String brandId, long executionTime, boolean hasAppId, boolean forceLogOut, @Nullable PushUnregisterType type, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        ArrayList<EventProperty> eventProperties = new ArrayList<EventProperty>();
        eventProperties.add(new EventProperty(API_VERSION, version.getValue()));
        eventProperties.add(new EventProperty(EXECUTION_TIME, executionTime));
        eventProperties.add(new EventProperty(HAS_APP_ID, hasAppId));
        eventProperties.add(new EventProperty(FORCE_LOGOUT, forceLogOut));
        PushUnregisterType pushUnregisterType = type;
        EventProperty[] eventPropertyArray = (EventProperty[])(pushUnregisterType != null ? pushUnregisterType.name() : null);
        if (!(eventPropertyArray == null || eventPropertyArray.length() == 0)) {
            PushUnregisterType pushUnregisterType2 = type;
            eventProperties.add(new EventProperty(PUSH_UNREGISTER_TYPE, pushUnregisterType2 != null ? pushUnregisterType2.name() : null));
        }
        if (!((eventPropertyArray = (CharSequence)error) == null || eventPropertyArray.length() == 0)) {
            eventProperties.add(new EventProperty(Error, error));
        }
        Collection $this$toTypedArray$iv = eventProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        eventPropertyArray = thisCollection$iv.toArray(new EventProperty[0]);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.LOGOUT, Arrays.copyOf(eventPropertyArray, eventPropertyArray.length)));
    }

    public final void trackHandlePushMessage(@NotNull LPAPIVersion version, @Nullable Context appContext, @Nullable String brandId, boolean showNotification, boolean isOutboundCampaignPush, @Nullable String backendService, @Nullable String error, boolean isProactiveRichContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        this.analyticsService.setAppContext(appContext);
        ArrayList<EventProperty> eventProperties = new ArrayList<EventProperty>();
        eventProperties.add(new EventProperty(IS_OUTBOUND_CAMPAIGN_PUSH, isOutboundCampaignPush));
        eventProperties.add(new EventProperty(API_VERSION, version.getValue()));
        eventProperties.add(new EventProperty(SHOW_NOTIFICATION, showNotification));
        eventProperties.add(new EventProperty(IS_PROACTIVE_RICH_CONTENT, isProactiveRichContent));
        EventProperty[] eventPropertyArray = (EventProperty[])backendService;
        if (!(eventPropertyArray == null || eventPropertyArray.length() == 0)) {
            eventProperties.add(new EventProperty(BACKEND_SERVICE, backendService));
        }
        if (!((eventPropertyArray = (CharSequence)error) == null || eventPropertyArray.length() == 0)) {
            eventProperties.add(new EventProperty(Error, error));
        }
        Collection $this$toTypedArray$iv = eventProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        eventPropertyArray = thisCollection$iv.toArray(new EventProperty[0]);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.HANDLE_PUSH, Arrays.copyOf(eventPropertyArray, eventPropertyArray.length)));
    }

    public void trackHideConversation(@NotNull LPAPIVersion version, @Nullable LPAuthenticationType authType, @Nullable String brandId, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.HIDE_CONVERSATION, eventPropertyArray));
    }

    public void trackUpdateTokenInBackground(@Nullable LPAuthenticationType authType, @Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.UPDATE_TOKEN_IN_BACKGROUND, eventPropertyArray));
    }

    public void trackSetCallback(@Nullable String brandId, boolean isListenerAvailable, @Nullable String error, boolean isSetCallback) {
        this.analyticsService.setBrandId(brandId);
        if (isSetCallback) {
            EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(HAS_CALLBACK, isListenerAvailable), new EventProperty(Error, error)};
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_CALLBACK, eventPropertyArray));
        } else {
            EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.REMOVE_CALLBACK, eventPropertyArray));
        }
    }

    public void trackSetUserProfile(@NotNull LPAPIVersion version, @Nullable String brandId, boolean hasAppId, boolean hasFirstName, boolean hasLastName, boolean hasPhoneNumber, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(HAS_APP_ID, hasAppId), new EventProperty(HAS_FIRST_NAME, hasFirstName), new EventProperty(HAS_LAST_NAME, hasLastName), new EventProperty(HAS_PHONE_NUMBER, hasPhoneNumber), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_USER_PROFILE, eventPropertyArray));
    }

    public void trackCheckActiveConversation(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.CHECK_ACTIVE_CONVERSATION, eventPropertyArray));
    }

    public void trackCheckConversationIsMarkedAsUrgent(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.CHECK_CONVERSATION_MARKED_URGENT, eventPropertyArray));
    }

    public void trackCheckAgentID(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.CHECK_AGENT_ID, eventPropertyArray));
    }

    public void trackMarkConversation(boolean isUrgent, @Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        if (isUrgent) {
            EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.MARK_CONVERSATION_URGENT, eventPropertyArray));
        } else {
            EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.MARK_CONVERSATION_NORMAL, eventPropertyArray));
        }
    }

    public void trackResolveConversation(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.RESOLVE_CONVERSATION, eventPropertyArray));
    }

    public void trackClearHistory(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.CLEAR_HISTORY, eventPropertyArray));
    }

    public void trackShutdown(@NotNull LPAPIVersion version, long startUpTime, @Nullable String brandId, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(STARTUP_TIME, startUpTime), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SHUTDOWN, eventPropertyArray));
    }

    public void trackSetImageServicePendingIntent(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_IMAGE_SERVICE_PENDING_INTENT, eventPropertyArray));
    }

    public void trackSetImageServiceUploadNotificationBuilder(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_IMAGE_SERVICE_UPLOPAD_NOTIFICATION_BUILDER, eventPropertyArray));
    }

    public void trackSetImageServiceDownloadNotificationBuilder(@Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_IMAGE_SERVICE_DOWNLOAD_NOTIFICATION_BUILDER, eventPropertyArray));
    }

    public void trackSetPushNotificationTapped(@NotNull LPAPIVersion version, @Nullable String brandId, boolean isOutboundCampaignPush, @Nullable String backendService, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        ArrayList<EventProperty> eventProperties = new ArrayList<EventProperty>();
        eventProperties.add(new EventProperty(IS_OUTBOUND_CAMPAIGN_PUSH, isOutboundCampaignPush));
        eventProperties.add(new EventProperty(API_VERSION, version.getValue()));
        EventProperty[] eventPropertyArray = (EventProperty[])backendService;
        if (!(eventPropertyArray == null || eventPropertyArray.length() == 0)) {
            eventProperties.add(new EventProperty(BACKEND_SERVICE, backendService));
        }
        if (!((eventPropertyArray = (CharSequence)error) == null || eventPropertyArray.length() == 0)) {
            eventProperties.add(new EventProperty(Error, error));
        }
        Collection $this$toTypedArray$iv = eventProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        eventPropertyArray = thisCollection$iv.toArray(new EventProperty[0]);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_PUSH_NOTIFICATIOM_TAPPED, Arrays.copyOf(eventPropertyArray, eventPropertyArray.length)));
    }

    public void trackSetLogLevel(@Nullable String brandId, @Nullable LogLevel logLevel, boolean isLogDump) {
        this.analyticsService.setBrandId(brandId);
        if (isLogDump) {
            EventProperty[] eventPropertyArray = new EventProperty[1];
            LogLevel logLevel2 = logLevel;
            eventPropertyArray[0] = new EventProperty(LOG_LEVEL, logLevel2 != null ? logLevel2.getApiName() : null);
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_LOG_LEVEL, eventPropertyArray));
        } else {
            EventProperty[] eventPropertyArray = new EventProperty[1];
            LogLevel logLevel3 = logLevel;
            eventPropertyArray[0] = new EventProperty(LOG_LEVEL, logLevel3 != null ? logLevel3.getApiName() : null);
            this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_LOG_LEVEL, eventPropertyArray));
        }
    }

    public void trackIsPusherRegistered(@Nullable LPAuthenticationType authType, boolean hasDeviceToken, @Nullable String brandId, @Nullable String error) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(HAS_NOTIFICATION_TOKEN, hasDeviceToken), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.IS_PUSHER_REGISTERED, eventPropertyArray));
    }

    public void trackUnRegisterPusher(@NotNull LPAPIVersion version, @Nullable String brandId, boolean hasAppId, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(API_VERSION, version.getValue()), new EventProperty(HAS_APP_ID, hasAppId), new EventProperty(Error, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.UNREGISTER_PUSHER, eventPropertyArray));
    }

    public void trackIsDebuggable(@Nullable String brandId, boolean isDebuggable) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(DEBUGGABLE, isDebuggable)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.IS_DEBUGGABLE, eventPropertyArray));
    }

    public void trackSetDataMasking(@Nullable String brandId, boolean dataMasking) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(DATA_MASKING, dataMasking)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.SET_DATA_MASKING, eventPropertyArray));
    }

    public void trackGetLogSnapshot(@Nullable String brandId, @Nullable LogLevel logLevel) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[1];
        LogLevel logLevel2 = logLevel;
        eventPropertyArray[0] = new EventProperty(LOG_LEVEL, logLevel2 != null ? logLevel2.getApiName() : null);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_LOG_SNAPSHOT, eventPropertyArray));
    }

    public void trackGetLogSnapshotString(@Nullable String brandId, @Nullable LogLevel logLevel) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[1];
        LogLevel logLevel2 = logLevel;
        eventPropertyArray[0] = new EventProperty(LOG_LEVEL, logLevel2 != null ? logLevel2.getApiName() : null);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_LOG_SNAPSHOT_STRING, eventPropertyArray));
    }

    public void trackGetLogSnapshotBlock(@Nullable String brandId, @Nullable LogLevel logLevel) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[1];
        LogLevel logLevel2 = logLevel;
        eventPropertyArray[0] = new EventProperty(LOG_LEVEL, logLevel2 != null ? logLevel2.getApiName() : null);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_LOG_SNAPSHOT_BLOCK, eventPropertyArray));
    }

    public void trackLoggingClearHistory(@Nullable String brandId) {
        this.analyticsService.setBrandId(brandId);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.LOGGING_CLEAR_HISTORY, new EventProperty[0]));
    }

    public void trackGetSDKVersion(@Nullable String brandId, @Nullable String sdkVersion) {
        this.analyticsService.setBrandId(brandId);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(LP_SDK_VERSION, sdkVersion)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_SDK_VERSION, eventPropertyArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/infra/analytics/events/LPAnalyticsFacade$Companion;", "", "()V", "API_VERSION", "", "AUTH_TYPE", "BACKEND_SERVICE", "DATA_MASKING", "DEBUGGABLE", "EXECUTION_TIME", "Error", "FORCE_LOGOUT", "HAS_APP_ID", "HAS_CALLBACK", "HAS_CAMPAIGN_INFO", "HAS_FIRST_NAME", "HAS_LAST_NAME", "HAS_NOTIFICATION_TOKEN", "HAS_PHONE_NUMBER", "IS_OUTBOUND_CAMPAIGN_PUSH", "IS_PROACTIVE_RICH_CONTENT", "LOG_LEVEL", "LP_SDK_VERSION", "PUSH_PLATFORM", "PUSH_UNREGISTER_TYPE", "SHOW_NOTIFICATION", "STARTUP_TIME", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

