/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.html;

import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import androidx.core.text.HtmlCompat;
import com.liveperson.infra.html.tag.ListTagHandler;
import com.liveperson.infra.log.LPLog;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"TAG", "", "convertHtmlToStyledString", "Landroid/text/SpannableString;", "infra_release"})
@JvmName(name="HtmlUtils")
public final class HtmlUtils {
    @NotNull
    private static final String TAG = "HtmlUtils";

    @NotNull
    public static final SpannableString convertHtmlToStyledString(@NotNull String $this$convertHtmlToStyledString) {
        Intrinsics.checkNotNullParameter((Object)$this$convertHtmlToStyledString, (String)"<this>");
        CharSequence charSequence = "<div>" + $this$convertHtmlToStyledString + "</div>";
        Object object = new Regex("(?i)<ul[^>]*>");
        String string = "<unordered>";
        charSequence = object.replace(charSequence, string);
        object = new Regex("(?i)</ul>");
        string = "</unordered>";
        charSequence = object.replace(charSequence, string);
        object = new Regex("(?i)<ol[^>]*>");
        string = "<ordered>";
        charSequence = object.replace(charSequence, string);
        object = new Regex("(?i)</ol>");
        string = "</ordered>";
        charSequence = object.replace(charSequence, string);
        object = new Regex("(?i)<li[^>]*>");
        string = "<listitem>";
        charSequence = object.replace(charSequence, string);
        object = new Regex("(?i)</li>");
        string = "</listitem>";
        String formattedString = object.replace(charSequence, string);
        try {
            Spanned spanned = HtmlCompat.fromHtml((String)formattedString, (int)63, null, (Html.TagHandler)new ListTagHandler());
            Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"{\n        HtmlCompat.fro\u2026, ListTagHandler())\n    }");
            object = (CharSequence)spanned;
        }
        catch (Throwable throwable) {
            LPLog.INSTANCE.d(TAG, "Error occurred while converting raw html to styled string", throwable);
            object = $this$convertHtmlToStyledString;
        }
        Object styledString = object;
        LPLog.INSTANCE.d(TAG, "Styled string " + (CharSequence)styledString);
        return new SpannableString((CharSequence)styledString);
    }
}

