/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.md;

import android.os.Build;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"HTML_LINK_FORMAT", "", "HTML_LINK_FORMAT_NO_COLOR", "MARKDOWN_REGEX", "MARKDOWN_REGEX_COMPAT", "convertMarkdownToHTML", "color", "", "markdownToHtml", "infra_release"})
@JvmName(name="MarkdownUtils")
public final class MarkdownUtils {
    @NotNull
    private static final String HTML_LINK_FORMAT = "<font color=\"%s\"><a href=\"%s\">%s</a></font>";
    @NotNull
    private static final String HTML_LINK_FORMAT_NO_COLOR = "<a href=\"%s\">%s</a></font>";
    @NotNull
    private static final String MARKDOWN_REGEX = "#md#\\[(?<text>(?:(?!#/?md).)+)\\]\\((?<link>(?:(?!#/?md).)+)\\)#/md#";
    @NotNull
    private static final String MARKDOWN_REGEX_COMPAT = "#md#\\[((?:(?!#/?md).)+)\\]\\(((?:(?!#/?md).)+)\\)#/md#";

    @NotNull
    public static final String convertMarkdownToHTML(@NotNull String $this$convertMarkdownToHTML, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$convertMarkdownToHTML, (String)"<this>");
        String regexString = Build.VERSION.SDK_INT >= 26 ? MARKDOWN_REGEX : MARKDOWN_REGEX_COMPAT;
        Pattern regex = Pattern.compile(regexString);
        Matcher matcher = regex.matcher($this$convertMarkdownToHTML);
        String result = $this$convertMarkdownToHTML;
        String string = "#%06X";
        Object[] objectArray = new Object[]{0xFFFFFF & color};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String hexColor = string2;
        while (matcher.find()) {
            String htmlLink;
            String text = matcher.group(1);
            String link = matcher.group(2);
            String string3 = HTML_LINK_FORMAT;
            Object[] objectArray2 = new Object[]{hexColor, link, text};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(this, *args)");
            String string4 = matcher.group(0);
            Intrinsics.checkNotNull((Object)string4);
            result = StringsKt.replaceFirst$default((String)result, (String)string4, (String)htmlLink, (boolean)false, (int)4, null);
        }
        return result;
    }

    @NotNull
    public static final String markdownToHtml(@NotNull String $this$markdownToHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$markdownToHtml, (String)"<this>");
        String regexString = Build.VERSION.SDK_INT >= 26 ? MARKDOWN_REGEX : MARKDOWN_REGEX_COMPAT;
        Pattern regex = Pattern.compile(regexString);
        Matcher matcher = regex.matcher($this$markdownToHtml);
        String result = $this$markdownToHtml;
        while (matcher.find()) {
            String htmlLink;
            String text = matcher.group(1);
            String link = matcher.group(2);
            String string = HTML_LINK_FORMAT_NO_COLOR;
            Object[] objectArray = new Object[]{link, text};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(this, *args)");
            String string2 = matcher.group(0);
            Intrinsics.checkNotNull((Object)string2);
            result = StringsKt.replaceFirst$default((String)result, (String)string2, (String)htmlLink, (boolean)false, (int)4, null);
        }
        return result;
    }
}

