/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.client.OkHttpClientHolder;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.otel.LPTelemetryAttributeKey;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.models.OtlpAttribute;
import com.liveperson.infra.otel.models.OtlpValueData;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpHandler {
    private static final String TAG = "HttpHandler";

    public static void executeDelayed(HttpRequest request, long delay) {
        Runnable httpRunnable = HttpHandler.buildRunnableByType(request);
        ThreadPoolExecutor.executeDelayed(httpRunnable, delay);
    }

    public static void execute(HttpRequest request) {
        HttpHandler.executeDelayed(request, 0L);
    }

    public static void cancelAllCalls() {
        OkHttpClientHolder.cancelAllRequests();
    }

    private static Runnable buildRunnableByType(final HttpRequest request) {
        return () -> {
            Request httpReq = HttpRequestBuilder.build(request);
            LPLog.INSTANCE.i(TAG, "URL: " + httpReq.url().host());
            LPLog.INSTANCE.d(TAG, "Sending http request: " + httpReq.url() + (request.getCertificatePinningKeys() != null && !request.getCertificatePinningKeys().isEmpty() ? " with Pinning Keys " + LPLog.INSTANCE.mask(TextUtils.join((CharSequence)",", request.getCertificatePinningKeys())) : " with no Pinning Keys"));
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPLog.INSTANCE.w(TAG, "No network connection.");
                request.processErrorResponse(new Exception("No network connection."));
                return;
            }
            ArrayList<OtlpAttribute> otlpAttributes = new ArrayList<OtlpAttribute>();
            otlpAttributes.add(new OtlpAttribute(LPTelemetryAttributeKey.URL_FULL.getValue(), new OtlpValueData.StringValue(request.getUrl())));
            otlpAttributes.add(new OtlpAttribute(LPTelemetryAttributeKey.METHOD.getValue(), new OtlpValueData.StringValue(request.getMethod().name())));
            final LPTraceSpan traceSpan = LPTelemetryManager.INSTANCE.begin(request.getTraceType(), otlpAttributes);
            OkHttpClientHolder.proceed(httpReq, request.getCertificatePinningKeys(), new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    LPLog.INSTANCE.w(HttpHandler.TAG, "onFailure ", e);
                    if (traceSpan != null) {
                        traceSpan.cancel();
                    }
                    request.processErrorResponse(e);
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) {
                    LPLog.INSTANCE.i(HttpHandler.TAG, "onResponse from URL: " + response.request().url());
                    if (traceSpan != null) {
                        traceSpan.end();
                    }
                    request.processResponse(response);
                }
            });
        };
    }

    private static class HttpRequestBuilder {
        private HttpRequestBuilder() {
        }

        public static Request build(HttpRequest request) {
            Request.Builder httpBuilder = new Request.Builder();
            httpBuilder.url(request.getUrl());
            switch (request.getMethod()) {
                case GET: {
                    httpBuilder.get();
                    break;
                }
                case HEAD: {
                    httpBuilder.head();
                    break;
                }
                case POST: {
                    httpBuilder.post(HttpRequestBuilder.getRequestBody(request));
                    break;
                }
                case PUT: {
                    httpBuilder.put(HttpRequestBuilder.getRequestBody(request));
                    break;
                }
                case DELETE: {
                    httpBuilder.delete();
                }
            }
            if (!request.getHeaders().isEmpty()) {
                Headers.Builder headersBuilder = new Headers.Builder();
                for (Pair<String, String> header : request.getHeaders()) {
                    LPLog.INSTANCE.d(HttpHandler.TAG, "header.first " + (String)header.first + " header.second " + (String)header.second);
                    if (header.first == null || header.second == null) continue;
                    try {
                        headersBuilder.add((String)header.first, (String)header.second);
                    }
                    catch (IllegalArgumentException illegalStateException) {
                        if (illegalStateException.getMessage() == null || !illegalStateException.getMessage().contains("Unexpected char")) continue;
                        headersBuilder.addUnsafeNonAscii((String)header.first, (String)header.second);
                        LPLog.INSTANCE.w(HttpHandler.TAG, illegalStateException.getMessage());
                    }
                }
                httpBuilder.headers(headersBuilder.build());
            }
            httpBuilder.addHeader("LP-timeout", String.valueOf(request.getTimeout()));
            return httpBuilder.build();
        }

        @NonNull
        private static RequestBody getRequestBody(HttpRequest request) {
            RequestBody reqBody;
            HttpRequestBody requestBody = request.getRequestBody();
            if (requestBody != null) {
                MediaType type = MediaType.parse((String)requestBody.getContentType());
                reqBody = requestBody.isString() ? RequestBody.create((MediaType)type, (String)((String)requestBody.get())) : RequestBody.create((MediaType)type, (byte[])((byte[])requestBody.get()));
            } else {
                reqBody = RequestBody.create(null, (byte[])new byte[0]);
            }
            return reqBody;
        }
    }
}

