/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.otel.LPTraceType;
import java.util.List;

public class SiteSettingsRequest
implements Command {
    private static final String TAG = "SiteSettingsRequest";
    private static final int REQUEST_TIMEOUT = 30000;
    private static final String SITE_SETTINGS_URL = "https://%s/api/account/%s/configuration/setting/accountproperties";
    private String mSiteSettingsDomain;
    private ICallback<String, Exception> mCallback;
    private String mBrandId;
    private List<String> mCertificates;

    public SiteSettingsRequest(String siteSettingsDomain, String brandId, List<String> certificates, ICallback<String, Exception> callback2) {
        this.mSiteSettingsDomain = siteSettingsDomain;
        this.mCallback = callback2;
        this.mBrandId = brandId;
        this.mCertificates = certificates;
    }

    @Override
    public void execute() {
        String siteSettingsUrl = String.format(SITE_SETTINGS_URL, this.mSiteSettingsDomain, this.mBrandId);
        HttpGetRequest httpGetRequest = new HttpGetRequest(siteSettingsUrl, LPTraceType.ACCDN_SETTINGS_REQ);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String siteSettingsJsonString) {
                if (!TextUtils.isEmpty((CharSequence)siteSettingsJsonString)) {
                    LPLog.INSTANCE.d(SiteSettingsRequest.TAG, "siteSettingsRequest - onCompleted " + siteSettingsJsonString);
                    SiteSettingsRequest.this.mCallback.onSuccess(siteSettingsJsonString);
                } else {
                    LPLog.INSTANCE.e(SiteSettingsRequest.TAG, ErrorCode.ERR_0000004C, "onSuccess: site settings string is empty");
                    SiteSettingsRequest.this.mCallback.onError(new Exception("site settings string is empty"));
                }
            }

            @Override
            public void onError(Exception e) {
                LPLog.INSTANCE.d(SiteSettingsRequest.TAG, "Exception: ", e);
                SiteSettingsRequest.this.mCallback.onError(e);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}

