/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.otel;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceSpanDelegate;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.otel.OtelUtils;
import com.liveperson.infra.otel.exporters.OtlpExporter;
import com.liveperson.infra.otel.models.OtlpAttribute;
import com.liveperson.infra.otel.models.OtlpSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0015J\u0014\u0010!\u001a\u00020\u00192\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tH\u0002R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/liveperson/infra/otel/LPTraceSpanCollector;", "Lcom/liveperson/infra/otel/LPTraceSpanDelegate;", "exporters", "", "Lcom/liveperson/infra/otel/exporters/OtlpExporter;", "autoExportThreshold", "", "(Ljava/util/List;I)V", "activeSpan", "Lcom/liveperson/infra/otel/LPTraceSpan;", "getActiveSpan", "()Lcom/liveperson/infra/otel/LPTraceSpan;", "setActiveSpan", "(Lcom/liveperson/infra/otel/LPTraceSpan;)V", "completedSpans", "", "spansMap", "", "", "begin", "dataType", "Lcom/liveperson/infra/otel/LPTraceType;", "attributes", "Lcom/liveperson/infra/otel/models/OtlpAttribute;", "cancel", "", "id", "end", "endActiveSpan", "export", "flush", "getSpanByTraceType", "traceType", "setExporters", "toOtlpSpan", "Lcom/liveperson/infra/otel/models/OtlpSpan;", "lpSpan", "Companion", "infra_release"})
@SourceDebugExtension(value={"SMAP\nLPTraceSpanCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LPTraceSpanCollector.kt\ncom/liveperson/infra/otel/LPTraceSpanCollector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1821#2,14:131\n37#3,2:145\n11335#4:147\n11670#4,3:148\n1855#5,2:151\n*S KotlinDebug\n*F\n+ 1 LPTraceSpanCollector.kt\ncom/liveperson/infra/otel/LPTraceSpanCollector\n*L\n82#1:131,14\n94#1:145,2\n94#1:147\n94#1:148,3\n98#1:151,2\n*E\n"})
public final class LPTraceSpanCollector
implements LPTraceSpanDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends OtlpExporter> exporters;
    private final int autoExportThreshold;
    @NotNull
    private final List<LPTraceSpan> completedSpans;
    @NotNull
    private Map<String, LPTraceSpan> spansMap;
    @Nullable
    private LPTraceSpan activeSpan;
    @NotNull
    private static final String TAG = "LPTraceSpanCollector";

    public LPTraceSpanCollector(@NotNull List<? extends OtlpExporter> exporters, int autoExportThreshold) {
        Intrinsics.checkNotNullParameter(exporters, (String)"exporters");
        this.exporters = exporters;
        this.autoExportThreshold = autoExportThreshold;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(\n        mutableListOf()\n    )");
        this.completedSpans = list;
        this.spansMap = new ConcurrentHashMap();
    }

    public /* synthetic */ LPTraceSpanCollector(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        this(list, n);
    }

    @Nullable
    public final LPTraceSpan getActiveSpan() {
        return this.activeSpan;
    }

    public final void setActiveSpan(@Nullable LPTraceSpan lPTraceSpan) {
        this.activeSpan = lPTraceSpan;
    }

    @JvmOverloads
    @NotNull
    public final LPTraceSpan begin(@NotNull LPTraceType dataType, @NotNull List<OtlpAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String traceId = null;
        String parentSpanId = null;
        if (this.activeSpan != null) {
            LPTraceSpan lPTraceSpan = this.activeSpan;
            Intrinsics.checkNotNull((Object)lPTraceSpan);
            traceId = lPTraceSpan.getTraceId();
            LPTraceSpan lPTraceSpan2 = this.activeSpan;
            Intrinsics.checkNotNull((Object)lPTraceSpan2);
            parentSpanId = lPTraceSpan2.getSpanId();
        } else {
            traceId = OtelUtils.INSTANCE.generateTraceId();
        }
        String spanId = OtelUtils.INSTANCE.generateSpanId();
        LPTraceSpan span = new LPTraceSpan(dataType.getValue(), OtelUtils.INSTANCE.getNanoTime(), spanId, traceId, null, 3, parentSpanId, attributes, this);
        this.spansMap.put(span.getSpanId(), span);
        LPLog.INSTANCE.d(TAG, "begin span has id = " + spanId);
        return span;
    }

    public static /* synthetic */ LPTraceSpan begin$default(LPTraceSpanCollector lPTraceSpanCollector, LPTraceType lPTraceType, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return lPTraceSpanCollector.begin(lPTraceType, list);
    }

    @Override
    public void end(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        LPTraceSpan span = this.spansMap.get(id);
        if (span == null || span.getEndTimeUnixNano() != null) {
            return;
        }
        span.setEndTimeUnixNano(OtelUtils.INSTANCE.getNanoTime());
        this.completedSpans.add(span);
        LPLog.INSTANCE.d(TAG, "ended span has id = " + span.getSpanId());
        if (this.autoExportThreshold > 0 && this.completedSpans.size() > this.autoExportThreshold) {
            this.export();
        }
        this.spansMap.remove(id);
    }

    @Override
    public void cancel(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.spansMap.remove(id);
    }

    @Nullable
    public final LPTraceSpan getSpanByTraceType(@NotNull LPTraceType traceType) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)((Object)traceType), (String)"traceType");
        Sequence $this$minByOrNull$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.spansMap.values()), (Function1)((Function1)new Function1<LPTraceSpan, Boolean>(traceType){
            final /* synthetic */ LPTraceType $traceType;
            {
                this.$traceType = $traceType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LPTraceSpan lpTraceSpan) {
                Intrinsics.checkNotNullParameter((Object)lpTraceSpan, (String)"lpTraceSpan");
                return Intrinsics.areEqual((Object)lpTraceSpan.getName(), (Object)this.$traceType.getValue());
            }
        }));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LPTraceSpan it = (LPTraceSpan)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getStartTimeUnixNano();
                do {
                    Object e$iv = iterator$iv.next();
                    LPTraceSpan it2 = (LPTraceSpan)e$iv;
                    $i$a$-minByOrNull-LPTraceSpanCollector$getSpanByTraceType$2 = false;
                    long v$iv = it2.getStartTimeUnixNano();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void setExporters(@NotNull List<? extends OtlpExporter> exporters) {
        Intrinsics.checkNotNullParameter(exporters, (String)"exporters");
        this.exporters = exporters;
    }

    /*
     * WARNING - void declaration
     */
    public final void export() {
        void $this$mapTo$iv$iv;
        if (this.exporters.isEmpty() || this.completedSpans.isEmpty()) {
            return;
        }
        LPTraceSpan[] $this$toTypedArray$iv = (LPTraceSpan[])this.completedSpans;
        boolean $i$f$toTypedArray = false;
        LPTraceSpan[] thisCollection$iv = $this$toTypedArray$iv;
        LPTraceSpan[] $this$map$iv = thisCollection$iv.toArray(new LPTraceSpan[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LPTraceSpan lPTraceSpan = (LPTraceSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toOtlpSpan((LPTraceSpan)it));
        }
        List spans = (List)destination$iv$iv;
        this.completedSpans.clear();
        Iterable $this$forEach$iv = this.exporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OtlpExporter it = (OtlpExporter)element$iv;
            boolean bl = false;
            it.export(spans);
        }
    }

    public final void flush() {
        this.spansMap.clear();
        this.completedSpans.clear();
    }

    public final void endActiveSpan() {
        LPTraceSpan lPTraceSpan = this.activeSpan;
        if (lPTraceSpan != null) {
            lPTraceSpan.end();
        }
        this.activeSpan = null;
    }

    private final OtlpSpan toOtlpSpan(LPTraceSpan lpSpan) {
        return new OtlpSpan(lpSpan.getName(), lpSpan.getStartTimeUnixNano(), lpSpan.getKind(), lpSpan.getSpanId(), lpSpan.getTraceId(), lpSpan.getEndTimeUnixNano(), lpSpan.getParentSpanId(), lpSpan.getAttributes());
    }

    @JvmOverloads
    @NotNull
    public final LPTraceSpan begin(@NotNull LPTraceType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return LPTraceSpanCollector.begin$default(this, dataType, null, 2, null);
    }

    public LPTraceSpanCollector() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/otel/LPTraceSpanCollector$Companion;", "", "()V", "TAG", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

