/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.otel.exporters;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.otel.OtelUtils;
import com.liveperson.infra.otel.exporters.OtlpExporter;
import com.liveperson.infra.otel.exporters.OtlpJsonObjectBody;
import com.liveperson.infra.otel.models.OtlpResource;
import com.liveperson.infra.otel.models.OtlpSpan;
import com.liveperson.infra.otel.models.OtlpTraceSpan;
import com.nimbusds.jose.shaded.gson.Gson;
import com.nimbusds.jose.shaded.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/liveperson/infra/otel/exporters/OtlpHttpExporter;", "Lcom/liveperson/infra/otel/exporters/OtlpExporter;", "endpoint", "", "resource", "Lcom/liveperson/infra/otel/models/OtlpResource;", "(Ljava/lang/String;Lcom/liveperson/infra/otel/models/OtlpResource;)V", "mEndpoint", "mResource", "addHeaders", "", "httpPostRequest", "Lcom/liveperson/infra/network/http/request/HttpPostRequest;", "export", "spans", "", "Lcom/liveperson/infra/otel/models/OtlpSpan;", "getHttpPostRequest", "requestBody", "Lcom/nimbusds/jose/shaded/gson/JsonObject;", "sendPostRequest", "Companion", "infra_release"})
public final class OtlpHttpExporter
implements OtlpExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String mEndpoint;
    @NotNull
    private OtlpResource mResource;
    @NotNull
    private static final String TAG = "OtlpHttpExporter";
    private static final int OTLP_EXPORTER_REQUEST_TIMEOUT = 30000;

    public OtlpHttpExporter(@NotNull String endpoint, @NotNull OtlpResource resource) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.mEndpoint = endpoint;
        this.mResource = resource;
    }

    @Override
    public void export(@NotNull List<OtlpSpan> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        OtlpTraceSpan traceSpan = OtelUtils.INSTANCE.createTrace(this.mResource, spans);
        Gson gson = new Gson();
        JsonObject jsonObject = gson.toJsonTree((Object)traceSpan).getAsJsonObject();
        if (jsonObject != null) {
            LPLog.INSTANCE.d(TAG, "Otel export body: " + jsonObject);
            this.sendPostRequest(this.getHttpPostRequest(jsonObject));
        }
    }

    private final void sendPostRequest(HttpPostRequest httpPostRequest) {
        LPLog.INSTANCE.d(TAG, "Otel sendPostRequest: url : " + httpPostRequest.getUrl());
        httpPostRequest.setTimeout(30000);
        HttpHandler.execute(httpPostRequest);
    }

    private final HttpPostRequest getHttpPostRequest(JsonObject requestBody) {
        HttpPostRequest httpPostRequest = new HttpPostRequest(this.mEndpoint, LPTraceType.NOT_TRACKING);
        HttpRequestBody body = new OtlpJsonObjectBody(requestBody);
        httpPostRequest.setBody(body);
        this.addHeaders(httpPostRequest);
        httpPostRequest.setCallback(new ICallback<String, Exception>(){

            public void onSuccess(@Nullable String value) {
                LPLog.INSTANCE.d("OtlpHttpExporter", "onSuccess");
            }

            public void onError(@Nullable Exception exception) {
                LPLog.INSTANCE.d("OtlpHttpExporter", "onError");
            }
        });
        return httpPostRequest;
    }

    private final void addHeaders(HttpPostRequest httpPostRequest) {
        httpPostRequest.addHeader("Content-type", "application/json");
        httpPostRequest.addHeader("Accept", "application/json");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/otel/exporters/OtlpHttpExporter$Companion;", "", "()V", "OTLP_EXPORTER_REQUEST_TIMEOUT", "", "TAG", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

