/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils.markdown

import android.text.SpannableStringBuilder
import android.text.Spanned
import androidx.annotation.ColorInt
import com.liveperson.infra.errors.ErrorCode.*
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.utils.LinkUtils

/**
 * Created by Yanda on 05/11/2020
 */
@Deprecated(message = "Please, use markdown utils class for it")
object HyperLinkUtils {

	private const val TAG = "HyperLinkUtils"

	/**
	 * Extract all hyperlinks from the message.
	 *
	 * @param message The message consumer received.
	 * @return A list of [MarkdownHyperlinkItem], which includes all hyperlinks.
	 */
	@JvmStatic
	fun buildHyperlinkList(message: String): List<MarkdownHyperlinkItem> {
		val tempHyperlinkList: MutableList<MarkdownHyperlinkItem> = ArrayList()
		var indexInsideTag = false //If current index is between LinkUtils.TAG_OPEN and LinkUtils.TAG_CLOSE
		var index = 0
		while (index <= message.length - LinkUtils.TAG_CLOSE.length) {
			if (!indexInsideTag && message.substring(index, index + LinkUtils.TAG_OPEN.length) == LinkUtils.TAG_OPEN) {
				val linkItem = MarkdownHyperlinkItem()
				linkItem.start = index
				tempHyperlinkList.add(linkItem)
				indexInsideTag = true
				index += LinkUtils.TAG_OPEN.length
			} else if (indexInsideTag && message.substring(index, index + LinkUtils.TAG_CLOSE.length) == LinkUtils.TAG_CLOSE) {
				val linkItem = tempHyperlinkList.last()
				index += LinkUtils.TAG_CLOSE.length
				linkItem.end = index
				linkItem.buildHyperlinkItem(message)
				indexInsideTag = false
			} else {
				index++
			}
		}
		val hyperlinkList: MutableList<MarkdownHyperlinkItem> = ArrayList()
		for (item in tempHyperlinkList) {
			//Put only valid link to the result. For example, the link item is invalid if the message contains only the opening tag.
			//Invalid markdown hyperlink should never happen. Adding additional check in SDK.
			if (item.isValid()) {
				hyperlinkList.add(item)
			} else {
				LPLog.e(TAG, ERR_00000149, "Invalid markdown hyperlink format.")
			}
		}
		return hyperlinkList
	}

	/**
	 * Build the hyperlink message for TextView.
	 *
	 * @param message The message consumer received.
	 * @param hyperlinkList The [MarkdownHyperlinkItem] list, which built from [buildHyperlinkList]
	 * @param hyperLinkColor color
	 * @return The ClickableSpan for TextView.
	 */
	@JvmStatic
	fun buildFormattedMessage(message: CharSequence, hyperlinkList: List<MarkdownHyperlinkItem>, @ColorInt hyperLinkColor: Int): SpannableStringBuilder {
		val formattedMessage = SpannableStringBuilder()
		var linkItemIndex = 0
		var index = 0
		while (index < message.length) {
			if (linkItemIndex < hyperlinkList.size) {
				val linkItem = hyperlinkList[linkItemIndex]
				val textBeforeOpenTag = message.substring(index, linkItem.start) // text from beginning or last close tag to current open tag.
				formattedMessage.append(textBeforeOpenTag)
				val title = linkItem.title
				formattedMessage.append(title)
				formattedMessage.setSpan(
					HyperlinkClickableSpan(linkItem.link, hyperLinkColor),
					formattedMessage.length - title!!.length, formattedMessage.length,
					Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
				linkItemIndex++
				index = linkItem.end
			} else {
				formattedMessage.append(message.substring(index))
				break
			}
		}
		return formattedMessage
	}

	/**
	 * Build the message text.
	 *
	 * @param message The message consumer received.
	 * @return The message without link and markdown hyperlink tags.
	 */
	@JvmStatic
	fun buildMessageString(message: String): String {
		val hyperlinkList = buildHyperlinkList(message)
		val messageBuilder = StringBuilder()
		var linkItemIndex = 0
		var index = 0
		while (index < message.length) {
			if (linkItemIndex < hyperlinkList.size) {
				val linkItem = hyperlinkList[linkItemIndex]
				val textBeforeOpenTag = message.substring(index, linkItem.start) // text from beginning or last close tag to current open tag.
				messageBuilder.append(textBeforeOpenTag)
						.append(linkItem.title)
				linkItemIndex++
				index = linkItem.end
			} else {
				messageBuilder.append(message.substring(index))
				break
			}
		}
		return messageBuilder.toString()
	}
}
