/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.analytics.events;

import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.analytics.AnalyticsService;
import com.liveperson.infra.analytics.EventName;
import com.liveperson.infra.analytics.EventProperty;
import com.liveperson.infra.auth.LPAuthenticationType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ*\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ2\u0010\u0011\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ*\u0010\u0014\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\nJ<\u0010\u0015\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/liveperson/infra/analytics/events/LPAnalyticsConsumerActions;", "", "analyticsService", "Lcom/liveperson/infra/analytics/AnalyticsService;", "(Lcom/liveperson/infra/analytics/AnalyticsService;)V", "trackClickStructuredContent", "", "authType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "language", "", "is_proactive_rich_content", "", "scActionType", "trackLoadSCImageFailed", "imageUrl", "error", "trackRequestConversation", "isOutBoundCampaignConversation", "transactionId", "trackShowProactiveAsWelcomeMessage", "trackStartNewConversation", "is_success", "conversationId", "Companion", "infra_release"})
public class LPAnalyticsConsumerActions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsService analyticsService;
    @NotNull
    private static final String AUTH_TYPE = "auth_type";
    @NotNull
    private static final String CONVERSATION_ID = "conversation_id";
    @NotNull
    private static final String LANGUAGE = "language";
    @NotNull
    private static final String IS_OUTBOUND_CAMPAIGN_CONVERSATION = "isOutBoundCampaignConversation";
    @NotNull
    private static final String IS_PROACTIVE_RICH_CONTENT = "richContent";
    @NotNull
    private static final String SC_ACTION_TYPE = "action";
    @NotNull
    private static final String TRANSACTION_ID = "transaction_id";
    @NotNull
    private static final String IS_SUCCESS = "isSuccessRequest";
    @NotNull
    private static final String ERROR_START_CONVO = "error_message";
    @NotNull
    private static final String IMAGE_URL = "url";
    @NotNull
    private static final String ERROR = "error";

    public LPAnalyticsConsumerActions(@NotNull AnalyticsService analyticsService) {
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        this.analyticsService = analyticsService;
    }

    public final void trackRequestConversation(@Nullable LPAuthenticationType authType, @NotNull String language, boolean isOutBoundCampaignConversation, boolean is_proactive_rich_content, @Nullable String transactionId) {
        Intrinsics.checkNotNullParameter((Object)language, (String)LANGUAGE);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(LANGUAGE, language), new EventProperty(IS_OUTBOUND_CAMPAIGN_CONVERSATION, isOutBoundCampaignConversation), new EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content), new EventProperty(TRANSACTION_ID, transactionId)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.ConsumerAction.REQUEST_CONVERSATION, eventPropertyArray));
    }

    public final void trackStartNewConversation(@Nullable LPAuthenticationType authType, @NotNull String language, boolean is_success, @NotNull String conversationId, @Nullable String transactionId, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)language, (String)LANGUAGE);
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(LANGUAGE, language), new EventProperty(IS_SUCCESS, is_success), new EventProperty(CONVERSATION_ID, conversationId), new EventProperty(TRANSACTION_ID, transactionId), new EventProperty(ERROR_START_CONVO, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.ConsumerAction.START_NEW_CONVERSATION, eventPropertyArray));
    }

    public final void trackShowProactiveAsWelcomeMessage(@Nullable LPAuthenticationType authType, @NotNull String language, boolean is_proactive_rich_content, @Nullable String transactionId) {
        Intrinsics.checkNotNullParameter((Object)language, (String)LANGUAGE);
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(LANGUAGE, language), new EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content), new EventProperty(TRANSACTION_ID, transactionId)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.ConsumerAction.SHOW_PROACTIVE_MESSAGE_IN_CONVERSATION, eventPropertyArray));
    }

    public final void trackClickStructuredContent(@Nullable LPAuthenticationType authType, @NotNull String language, boolean is_proactive_rich_content, @NotNull String scActionType) {
        Intrinsics.checkNotNullParameter((Object)language, (String)LANGUAGE);
        Intrinsics.checkNotNullParameter((Object)scActionType, (String)"scActionType");
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(LANGUAGE, language), new EventProperty(IS_PROACTIVE_RICH_CONTENT, is_proactive_rich_content), new EventProperty(SC_ACTION_TYPE, scActionType)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.ConsumerAction.CLICK_STRUCTURED_CONTENT, eventPropertyArray));
    }

    public final void trackLoadSCImageFailed(@Nullable LPAuthenticationType authType, @NotNull String language, @NotNull String imageUrl, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)language, (String)LANGUAGE);
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        EventProperty[] eventPropertyArray = new EventProperty[]{new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(LANGUAGE, language), new EventProperty(IMAGE_URL, imageUrl), new EventProperty(ERROR, error)};
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.ConsumerAction.LOAD_SC_IMAGE_FAILED, eventPropertyArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/liveperson/infra/analytics/events/LPAnalyticsConsumerActions$Companion;", "", "()V", "AUTH_TYPE", "", "CONVERSATION_ID", "ERROR", "ERROR_START_CONVO", "IMAGE_URL", "IS_OUTBOUND_CAMPAIGN_CONVERSATION", "IS_PROACTIVE_RICH_CONTENT", "IS_SUCCESS", "LANGUAGE", "SC_ACTION_TYPE", "TRANSACTION_ID", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

