package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.types.NotificationType;
import com.liveperson.infra.utils.ClockUtils;
import com.liveperson.infra.utils.PushMessageParser;

/**
 * Created by shiranr on 18/01/2016.
 */
public class PushMessage implements Parcelable {
    private static final String TAG = PushMessage.class.getSimpleName();

    private String mBrandId;
    private String mMessage;
    private String title;
    private String mFrom;
    private String mConversationId;
    private String mBackendService;
    private String mCollapseKey;
    private int mCurrentUnreadMessagesCounter = -1;
    private String id;
    private Long lookBackPeriod = -1L;
    private Long timeCreated;
    private String agentPid;
    private String transactionId; // Valid only for proactive/C2M
    private CampaignInfo campaignInfo;
    private String messageEvent;
    private Long expirationEpochTime = -1L;
    private NotificationType notificationType;

    public PushMessage(String brandId, String from, String message) {
        this.mBrandId = brandId;
        this.mFrom = from;
        this.mMessage = message;
        this.timeCreated = System.currentTimeMillis();
        this.id = String.valueOf(timeCreated);
        this.notificationType = NotificationType.REGULAR;
    }

    public PushMessage(String brandId, String from, String message, long createdDate) {
        this.mBrandId = brandId;
        this.mFrom = from;
        this.mMessage = message;
        this.timeCreated = createdDate;
        this.id = String.valueOf(timeCreated);
        this.notificationType = NotificationType.REGULAR;
    }

    private PushMessage(Parcel in) {
        mBrandId = in.readString();
        mFrom = in.readString();
        mMessage = in.readString();
        title = in.readString();
        id  = in.readString();
        timeCreated = in.readLong();
        lookBackPeriod = in.readLong();
        campaignInfo = in.readParcelable(CampaignInfo.class.getClassLoader());
        messageEvent = in.readString();
        expirationEpochTime = in.readLong();
    }

    public void setFrom(String from) {
        this.mFrom = from;
    }

    public String getFrom() {
        return mFrom;
    }

    public String getMessage() {
        return mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBrandId() {
        return mBrandId;
    }

    public String getConversationId() {
        return mConversationId;
    }

    public void setConversationId(String mConversationId) {
        this.mConversationId = mConversationId;
    }

    public String getBackendService() {
        return mBackendService;
    }

    public void setBackendService(String mBackendService) {
        this.mBackendService = mBackendService;
    }

    public String getCollapseKey() {
        return mCollapseKey;
    }

    public void setCollapseKey(String mCollapseKey) {
        this.mCollapseKey = mCollapseKey;
    }

    public void setCampaignInfo(CampaignInfo campaignInfo) {
        this.campaignInfo = campaignInfo;
    }

    public String getPushMessageId() {
        return id;
    }

    public void setPushMessageId(String msgId) {
        id = msgId;
    }

    public void setTimeCreated(Long time) {
        this.timeCreated = time;
    }

    public Long getTimeCreated() {
        return timeCreated;
    }

    public void setLookBackPeriod(Long period) {
        this.lookBackPeriod = period;
    }

    public Long getLookBackPeriod() {
        return this.lookBackPeriod;
    }

    public String getAgentPid() {
        return agentPid;
    }

    public void setAgentPid(String agentPid) {
        this.agentPid = agentPid;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public CampaignInfo getCampaignInfo() {
        return campaignInfo;
    }

    public String getMessageEvent() {
        return messageEvent;
    }

    public void setMessageEvent(String messageEvent) {
        this.messageEvent = messageEvent;
    }

    public Long getExpirationEpochTime() {
        return expirationEpochTime;
    }

    public void setExpirationEpochTime(Long expirationEpochTime) {
        this.expirationEpochTime = expirationEpochTime;
    }

    public void setNotificationType(NotificationType type) {
        this.notificationType = type;
    }

    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    /**
     * Check If outbound campaign has expired
     * @return boolean
     */
    public boolean isExpired() {
        // If expirationEpochTime equal the default value(-1), we should not mark notification as expired.
        if (expirationEpochTime == -1) {
            return false;
        }
        LPLog.INSTANCE.d(TAG, "current: " + ClockUtils.getSyncedTimestamp() + " - expired: " + expirationEpochTime);
        return ClockUtils.getSyncedTimestamp() - expirationEpochTime >= 0;
    }

    @Override
    public String toString() {
        return "mBrandId: "+mBrandId+ " from: " + mFrom + " Message: " + mMessage + " convId: "
                +mConversationId + " mCollapseKey: " + mCollapseKey  + " mBackendService: " + mBackendService;
    }

    public int getCurrentUnreadMessagesCounter() {
        return mCurrentUnreadMessagesCounter;
    }

    public void setCurrentUnreadMessagesCounter(int currentUnreadMessagesCounter) {
        this.mCurrentUnreadMessagesCounter = currentUnreadMessagesCounter;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mBrandId);
        dest.writeString(mFrom);
        dest.writeString(mMessage);
        dest.writeString(title);
        dest.writeString(id);
        dest.writeLong(timeCreated);
        dest.writeLong(lookBackPeriod);
        dest.writeParcelable(campaignInfo, flags);
        dest.writeString(messageEvent);
        dest.writeLong(expirationEpochTime);
    }

    public static final Parcelable.Creator<PushMessage> CREATOR
            = new Parcelable.Creator<PushMessage>() {
        public PushMessage createFromParcel(Parcel in) {
            return new PushMessage(in);
        }

        public PushMessage[] newArray(int size) {
            return new PushMessage[size];
        }
    };
}
