package com.liveperson.infra.utils;

import android.util.LruCache;

import com.liveperson.infra.log.LPLog;

/**
 * Created by Maayan on 17/2/17.
 * A cache that holds strong references of link preview data type to a limited number of values.
 * Each time a value is accessed, it is moved to the head of a queue. When a value is
 * added to a full cache, the value at the end of that queue is evicted and may
 * become eligible for garbage collection.
 * we are saving @numOfObjects size (30 by  default)
 */
public class LinkPreviewLruCache {

	private static final String TAG = "LinkPreviewLruCache";
	private static final int DEFAULT_NUM_OF_OBJECTS = 10;
	private static LinkPreviewLruCache INSTANCE;
	private LruCache<String, SourceContent> mLruCache;

	private LinkPreviewLruCache() {
		mLruCache = new LruCache<>(DEFAULT_NUM_OF_OBJECTS);
	}

	public static LinkPreviewLruCache getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new LinkPreviewLruCache();
		}
		return INSTANCE;
	}

	public void addSourceContentToCache(SourceContent content) {
		if (content == null) {
			return;
		}
		String key = content.getFinalUrl();
		if (getSourceContentFromCache(key) == null) {
			LPLog.INSTANCE.d(TAG, "cache -- : ADD Key: " + key + " in total: "+ mLruCache.size());
			mLruCache.put(key, content);
		}
	}

	public SourceContent getSourceContentFromCache(String key) {
		if (key == null) {
			return null;
		}
		key = key.toLowerCase();
		if (mLruCache.get(key) != null) {
			LPLog.INSTANCE.d(TAG, "cache -- : GET found: " + key + " hit count: " + mLruCache.hitCount());
		}
		return mLruCache.get(key);
	}
}
