/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils;

import android.content.Context;
import androidx.annotation.NonNull;

import com.liveperson.infra.network.http.client.OkHttpClientHolder;
import com.squareup.picasso.OkHttp3Downloader;
import com.squareup.picasso.Picasso;

import okhttp3.OkHttpClient;

/**
 * Created by Yanda on 2019/07/30
 * Picasso util class to enable TLSv1.2 for Android 4.4
 * todo: create interface for mocking
 */
public class PicassoUtils {

    private static Picasso sInstance;

    public static Picasso get(@NonNull Context context) {
        if (sInstance == null) {
            sInstance = new Picasso.Builder(context.getApplicationContext()).build();
        }
        return sInstance;
    }
}
