package com.liveperson.infra.preferences

import android.content.Context
import android.content.SharedPreferences
import androidx.annotation.VisibleForTesting
import com.liveperson.infra.log.LPLog.d

class AuthPreferences private constructor(applicationContext: Context) {
    private var preferences: SharedPreferences? = null

    init {
        preferences = applicationContext.getSharedPreferences(LP_AUTH_SHARED_PREF_FILENAME, Context.MODE_PRIVATE)
    }

    companion object {
        private const val TAG = "AuthPreferences"
        private const val LP_AUTH_SHARED_PREF_FILENAME = "lp_auth_shared_pref"
        private const val KEY_ACCOUNT_UN_AUTH_TOKEN = "account_un_auth_token"

        private var instance: AuthPreferences? = null
        // Create singleton instance
        fun getInstance(context: Context): AuthPreferences {
            if (instance == null) {
                instance = AuthPreferences(context)
            }
            return instance as AuthPreferences
        }
    }

    /**
     * Set mocked SharedPreferences object. Used only for testing.
     */
    @VisibleForTesting
    fun setPreferenceDelegate(prefs: SharedPreferences?) {
        preferences = prefs
    }
    /**
     * Store Encrypted Un Auth token into shared preferences
     */
    fun setUnAuthToken(brandId: String?, value: String?) {
        preferences?.edit()?.putString(buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), value)?.apply()
    }

    /**
     * Return Encrypted Un Auth token into shared preferences
     */
    fun getUnAuthToken(brandId: String?, defaultValue: String?): String? {
        return preferences?.getString(buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), defaultValue)
    }

    private fun buildKey(key: String?, brandId: String?): String? {
        return "$key$$$brandId"
    }

    /**
     * Clear all entries from Auth preferences
     */
    fun clearAll() {
        d(TAG, "clearAll: Clearing all data of Auth preferences")
        preferences?.edit()?.clear()?.apply()
    }
}