/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.analytics.events;

import android.content.Context;
import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.analytics.AnalyticsService;
import com.liveperson.infra.analytics.EventName;
import com.liveperson.infra.analytics.EventProperty;
import com.liveperson.infra.analytics.LPAPIVersion;
import com.liveperson.infra.auth.LPAuthenticationType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\"\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ4\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ2\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\"\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ4\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/liveperson/infra/analytics/events/LivePersonFacade;", "", "analyticsService", "Lcom/liveperson/infra/analytics/AnalyticsService;", "(Lcom/liveperson/infra/analytics/AnalyticsService;)V", "trackDisplayConversation", "", "version", "Lcom/liveperson/infra/analytics/LPAPIVersion;", "authType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "hasCampaignInfo", "", "isUsingFragment", "error", "", "trackGetUnreadMessageCount", "trackHandlePushMessage", "appContext", "Landroid/content/Context;", "brandId", "showNotification", "trackInit", "startUpTime", "", "trackLogout", "executionTime", "hasAppId", "trackReconnect", "trackRegisterLPPusher", "isPushTokenProvided", "Companion", "infra_release"})
public class LivePersonFacade {
    private final AnalyticsService analyticsService;
    private static final String API_VERSION = "api_version";
    private static final String STARTUP_TIME = "startup_time";
    private static final String EXECUTION_TIME = "execution_time";
    private static final String AUTH_TYPE = "auth_type";
    private static final String HAS_CAMPAIGN_INFO = "has_campaign_info";
    private static final String HAS_NOTIFICATION_TOKEN = "has_notification_token";
    private static final String HAS_APP_ID = "has_app_id";
    private static final String SHOW_NOTIFICATION = "show_notification";
    private static final String Error = "error";
    public static final Companion Companion = new Companion(null);

    public final void trackInit(@NotNull LPAPIVersion version, long startUpTime, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.INITIALIZE, new EventProperty(API_VERSION, version.getValue()), new EventProperty(STARTUP_TIME, startUpTime), new EventProperty(Error, error)));
    }

    public final void trackDisplayConversation(@NotNull LPAPIVersion version, @Nullable LPAuthenticationType authType, boolean hasCampaignInfo, boolean isUsingFragment, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        EventName.LivePerson eventName = isUsingFragment ? EventName.LivePerson.SHOW_CONVERSATION_HOST_CONTROL : EventName.LivePerson.SHOW_CONVERSATION_LP_CONTROL;
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)eventName, new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(HAS_CAMPAIGN_INFO, hasCampaignInfo), new EventProperty(Error, error)));
    }

    public final void trackRegisterLPPusher(@NotNull LPAPIVersion version, @Nullable String brandId, @Nullable LPAuthenticationType authType, boolean isPushTokenProvided, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.REGISTER_PUSHER, new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(HAS_NOTIFICATION_TOKEN, isPushTokenProvided), new EventProperty(Error, error)));
    }

    public final void trackGetUnreadMessageCount(@NotNull LPAPIVersion version, @Nullable LPAuthenticationType authType, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.GET_UNREAD_MESSAGES_COUNT, new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(Error, error)));
    }

    public final void trackReconnect(@NotNull LPAPIVersion version, @Nullable LPAuthenticationType authType, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.RECONNECT, new EventProperty(API_VERSION, version.getValue()), new EventProperty(AUTH_TYPE, (Object)authType), new EventProperty(Error, error)));
    }

    public final void trackLogout(@NotNull LPAPIVersion version, @Nullable String brandId, long executionTime, boolean hasAppId, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.LOGOUT, new EventProperty(API_VERSION, version.getValue()), new EventProperty(EXECUTION_TIME, executionTime), new EventProperty(HAS_APP_ID, hasAppId), new EventProperty(Error, error)));
    }

    public final void trackHandlePushMessage(@NotNull LPAPIVersion version, @Nullable Context appContext, @Nullable String brandId, boolean showNotification, @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        this.analyticsService.setBrandId(brandId);
        this.analyticsService.setAppContext(appContext);
        this.analyticsService.logUserEvent(new AnalyticsEvent((Object)EventName.LivePerson.HANDLE_PUSH, new EventProperty(API_VERSION, version.getValue()), new EventProperty(SHOW_NOTIFICATION, showNotification), new EventProperty(Error, error)));
    }

    public LivePersonFacade(@NotNull AnalyticsService analyticsService) {
        Intrinsics.checkParameterIsNotNull((Object)analyticsService, (String)"analyticsService");
        this.analyticsService = analyticsService;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/liveperson/infra/analytics/events/LivePersonFacade$Companion;", "", "()V", "API_VERSION", "", "AUTH_TYPE", "EXECUTION_TIME", "Error", "HAS_APP_ID", "HAS_CAMPAIGN_INFO", "HAS_NOTIFICATION_TOKEN", "SHOW_NOTIFICATION", "STARTUP_TIME", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

