/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.configuration;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.res.ResourcesCompat;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration {
    private static final String TAG = "Configuration";
    private static final String SHARED_PREFERENCES_FILE_NAME = "lp_runtime_config";
    private static final String RUNTIME_CONFIGURATION_KEYS = "runtimeConfigurationKeys";

    public static boolean getBoolean(@BoolRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        return sharedPreferences.getBoolean(String.valueOf(resId), context.getResources().getBoolean(resId));
    }

    public static float getDimension(@DimenRes int resId) {
        float result;
        Context context = Infra.instance.getApplicationContext();
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
            result = sharedPreferences.getFloat(String.valueOf(resId), context.getResources().getDimension(resId));
        }
        catch (Resources.NotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000002F, "getDimension: ", e);
            result = -1.0f;
        }
        return result;
    }

    public static int getInteger(@IntegerRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        return sharedPreferences.getInt(String.valueOf(resId), context.getResources().getInteger(resId));
    }

    public static String getString(@StringRes int resId) throws Resources.NotFoundException {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        return sharedPreferences.getString(String.valueOf(resId), context.getResources().getString(resId));
    }

    public static int getColor(@ColorRes int resId) {
        int result;
        Context context = Infra.instance.getApplicationContext();
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
            result = sharedPreferences.getInt(String.valueOf(resId), ResourcesCompat.getColor((Resources)context.getResources(), (int)resId, null));
        }
        catch (Resources.NotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000030, "getColor: ", e);
            result = -1;
        }
        return result;
    }

    public static void set(int resId, String stringValue) {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        sharedPreferences.edit().putString(String.valueOf(resId), stringValue).apply();
        Configuration.save(resId, stringValue);
    }

    public static void set(int resId, boolean booleanValue) {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        sharedPreferences.edit().putBoolean(String.valueOf(resId), booleanValue).apply();
        Configuration.save(resId, booleanValue);
    }

    public static void set(int resId, float floatValue) {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        sharedPreferences.edit().putFloat(String.valueOf(resId), floatValue).apply();
        Configuration.save(resId, Float.valueOf(floatValue));
    }

    public static void set(int resId, int intValue) {
        Context context = Infra.instance.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
        sharedPreferences.edit().putInt(String.valueOf(resId), intValue).apply();
        Configuration.save(resId, intValue);
    }

    public static void clearAll() {
        Context context = Infra.instance.getApplicationContext();
        context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0).edit().clear().apply();
    }

    private static void save(int resId, @Nullable Object resValue) {
        if (resValue == null) {
            Context context = Infra.instance.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_FILE_NAME, 0);
            sharedPreferences.edit().remove(String.valueOf(resId)).apply();
        }
    }

    public static HashMap<Integer, String> scanXmlIdsAndNames(Class<?> rInnerClass) {
        HashMap<Integer, String> fieldIdMap = new HashMap<Integer, String>();
        if (rInnerClass == null) {
            return fieldIdMap;
        }
        try {
            Field[] fields = rInnerClass.getFields();
            Set<String> keys = Configuration.getConfigurationKeySet();
            for (Field field : fields) {
                if (field == null) continue;
                int id = field.getInt(null);
                if (!keys.contains(field.getName())) continue;
                fieldIdMap.put(id, field.getName());
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000031, "Failed to generate key-value map.", e);
        }
        return fieldIdMap;
    }

    private static Set<String> getConfigurationKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        try {
            JSONObject configurationKeysJsonObject = new JSONObject(Configuration.loadConfigurationKeysJsonString());
            JSONArray configurationKeysJsonArray = configurationKeysJsonObject.getJSONArray(RUNTIME_CONFIGURATION_KEYS);
            for (int i = 0; i < configurationKeysJsonArray.length(); ++i) {
                keySet.add(configurationKeysJsonArray.getString(i));
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000032, "JSONException while parsing configurationKeys JSON.", e);
        }
        return keySet;
    }

    private static String loadConfigurationKeysJsonString() {
        String json = null;
        try {
            InputStream is = Utils.getResources().openRawResource(R.raw.runtime_configuration_keys);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000033, "IOException while loading configurationKeys from disk.", e);
        }
        return json;
    }
}

