/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.log.LPLog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u0011\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "buildKey", "", "key", "brandId", "clearAll", "", "getUnAuthToken", "defaultValue", "setPreferenceDelegate", "prefs", "setUnAuthToken", "value", "Companion", "infra_release"})
public final class AuthPreferences {
    private SharedPreferences preferences;
    private static final String TAG = "AuthPreferences";
    private static final String LP_AUTH_SHARED_PREF_FILENAME = "lp_auth_shared_pref";
    private static final String KEY_ACCOUNT_UN_AUTH_TOKEN = "account_un_auth_token";
    private static AuthPreferences instance;
    public static final Companion Companion;

    @VisibleForTesting
    public final void setPreferenceDelegate(@Nullable SharedPreferences prefs) {
        this.preferences = prefs;
    }

    public final void setUnAuthToken(@Nullable String brandId, @Nullable String value) {
        block0: {
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), value)) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @Nullable
    public final String getUnAuthToken(@Nullable String brandId, @Nullable String defaultValue) {
        SharedPreferences sharedPreferences = this.preferences;
        return sharedPreferences != null ? sharedPreferences.getString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), defaultValue) : null;
    }

    private final String buildKey(String key, String brandId) {
        return key + "$$" + brandId;
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "clearAll: Clearing all data of Auth preferences");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    private AuthPreferences(Context applicationContext) {
        this.preferences = applicationContext.getSharedPreferences(LP_AUTH_SHARED_PREF_FILENAME, 0);
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ AuthPreferences(Context applicationContext, DefaultConstructorMarker $constructor_marker) {
        this(applicationContext);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences$Companion;", "", "()V", "KEY_ACCOUNT_UN_AUTH_TOKEN", "", "LP_AUTH_SHARED_PREF_FILENAME", "TAG", "instance", "Lcom/liveperson/infra/preferences/AuthPreferences;", "getInstance", "context", "Landroid/content/Context;", "infra_release"})
    public static final class Companion {
        @NotNull
        public final AuthPreferences getInstance(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (instance == null) {
                instance = new AuthPreferences(context, null);
            }
            AuthPreferences authPreferences = instance;
            if (authPreferences == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.liveperson.infra.preferences.AuthPreferences");
            }
            return authPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

