package com.liveperson.infra.network.http.requests;

import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import static com.liveperson.infra.errors.ErrorCode.ERR_0000004D;

/**
 * Created by nirni on 1/27/16.
 */
public class UnregisterPushRequest extends PushRequest {

	private static final String TAG = "UnregisterPushRequest";


	public UnregisterPushRequest(String pusherURL, String userId, String appId, List<String> certificates) {
		super(pusherURL, userId, appId, null, null, certificates);
	}

	@Override
	public void handleResponse(String json) {
		if (!TextUtils.isEmpty(json)) {
			LPLog.INSTANCE.d(TAG, "onSuccess " + json);
			if (mCallback != null) {
				mCallback.onSuccess(null);
			}
		}else{
			LPLog.INSTANCE.e(TAG, ERR_0000004D, "Unregister pusher with empty response");
		}
	}

	@Override
	public void handleError(Exception exception) {
		if (exception != null) {
			LPLog.INSTANCE.d(TAG, "onError ", exception);
			if (mCallback != null) {
				if (exception.getMessage().contains("Token not found")) {
					LPLog.INSTANCE.d(TAG, "handleError: token not found on pusher. Return success");
					mCallback.onSuccess(null);
					return;
				}
				mCallback.onError(new Exception("Failed to unregister to pusher. response message = ", exception));
			}
		}
	}

	@NonNull
	@Override
	protected JSONObject getBody() {

		JSONObject pusherJson = new JSONObject();

		try {
			pusherJson.put(KEY_APP_ID, mAppId);
			pusherJson.put(KEY_USER_ID, mUserId);
			pusherJson.put(KEY_PLATFORM, mPlatform);

		} catch (JSONException ignored) {}

		return pusherJson;
	}
}
