package com.liveperson.infra.statemachine.interfaces;

/**
 * Created by shiranr on 13/03/2016.
 */
public interface IStateMachine <STATE extends IState>{
    STATE activeState();

    void apply(IEvent iEvent);

    void postEvent(final IEvent event);

    Runnable postDelayEvent(final IEvent event, long delay);

    void changeState(STATE iState);

    void changeStateAndPassEvent(STATE nextState, IEvent ev);

    String getTag();

    void initActiveState(STATE iState);

    void setStateMachineExecutor(IStateMachineExecutor stateMachineExecutor);
}