/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class DocumentUtils {
    private static final String TAG = "DocumentUtils";
    private static final String DOCUMENTS_FOLDER = "documents/";
    private static final List<String> knownExtensions = Arrays.asList("pdf", "docx", "pptx", "xlsx");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getDocumentSize(Uri uri, Context context) {
        String fileScheme = uri.getScheme();
        if (fileScheme != null && fileScheme.equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);){
                if (cursor == null) return 0;
                if (!cursor.moveToFirst()) return 0;
                int sizeIndex = cursor.getColumnIndex("_size");
                if (!cursor.isNull(sizeIndex)) {
                    String size = cursor.getString(sizeIndex);
                    int n = Integer.parseInt(size);
                    return n;
                }
                int n = 0;
                return n;
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001B, "Failed to get document size", e);
                return 0;
            }
        }
        try {
            File file = new File(uri.getPath());
            int size = (int)file.length();
            LPLog.INSTANCE.d(TAG, "File size: " + size);
            return size;
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001C, "Failed to calculate file size", e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDocumentName(Uri uri, Context context) {
        String fileScheme = uri.getScheme();
        if (fileScheme != null && fileScheme.equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);){
                if (cursor == null) return null;
                if (!cursor.moveToFirst()) return null;
                String displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
                LPLog.INSTANCE.i(TAG, "File Name: " + displayName);
                String string = displayName;
                return string;
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001D, "Failed to retrieve file name", e);
                return null;
            }
        }
        try {
            File file = new File(uri.getPath());
            return file.getName();
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001E, "Failed to retrieve file name", e);
        }
        return null;
    }

    public static String saveOriginalDocument(Uri uri, Context context, String brandId, byte[] documentByteArray) {
        String documentName = DocumentUtils.getDocumentName(uri, context);
        String filename = UUID.randomUUID().toString();
        String fileExtension = DocumentUtils.getDocumentExtension(uri, context, documentName);
        if (fileExtension != null) {
            filename = filename + "." + fileExtension;
        }
        LPLog.INSTANCE.d(TAG, "new file name: " + filename);
        return DocumentUtils.saveDocumentToDisk(context, filename, brandId, documentByteArray);
    }

    private static String getDocumentExtension(Uri uri, Context context, String documentName) {
        String[] documentNameArray = documentName.split("\\.");
        String extension = documentNameArray[documentNameArray.length - 1];
        if (!TextUtils.isEmpty((CharSequence)extension) && knownExtensions.contains(extension.toLowerCase())) {
            return extension;
        }
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            String mimeType = context.getContentResolver().getType(uri);
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            return extension;
        }
        return null;
    }

    private static String saveDocumentToDisk(Context context, String fileName, String brandId, byte[] documentByteArray) {
        String path = "/documents/" + brandId;
        File filePath = FileUtils.getFilePath(context, path, fileName);
        if (filePath == null) {
            return null;
        }
        return DocumentUtils.saveDocumentToDisk(documentByteArray, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String saveDocumentToDisk(byte[] documentByteArray, File filePath) {
        LPLog.INSTANCE.d(TAG, "saveDocumentToDisk: filePath: " + filePath.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(documentByteArray);
        }
        catch (FileNotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000001F, "saveDocumentToDisk: File not found", e);
            String string = null;
            return string;
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000020, "saveDocumentToDisk: IOException", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000021, "saveDocumentToDisk: error closing file", e);
                return null;
            }
        }
        LPLog.INSTANCE.d(TAG, "saveDocumentToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }
}

