package com.liveperson.infra.configuration;

import com.liveperson.infra.Infra;
import com.liveperson.infra.R;

/**
 * Created by nirni on 9/11/17.
 *
 * This class holds the LPTag environment with which we should work (QA, Alpha, Production).
 * We need this since the domain of each environment is different. For testing we need to work mainly with QA
 * but customers need to work with production.
 * Default value if not set is Production.
 *
 * To get the domain for the set environment call getLptagDomain() method.
 */
public class LptagEnvironment {

	public static final String LPTAG_ALPHA_DOMAIN = "lptag-a.liveperson.net";

	// Environment enum
	public enum Env{
		PRODUCTION,
		ALPHA,
		QA
	}

	private Env mEnvironment;

	/**
	 * Sets the environment by default to Production
	 */
	public LptagEnvironment() {
		mEnvironment = Env.PRODUCTION;
	}

	/**
	 * Get the LPTag domain according to the environment set
	 * @return
	 */
	public String getLptagDomain(){
		switch (mEnvironment) {
			case ALPHA:
				return LPTAG_ALPHA_DOMAIN;
			case QA:
				return Infra.instance.getApplicationContext().getResources().getString(R.string.lptag_qa_domain);
			default: // production
				return Infra.instance.getApplicationContext().getResources().getString(R.string.lptag_domain);
		}
	}

	public Env getEnvironment() {
		return mEnvironment;
	}

	public void setEnvironment(Env environment) {
		mEnvironment = environment;
	}
}
